# coding=utf-8
import json
import xml.etree.ElementTree as ET
from datetime import datetime, timedelta
from time import sleep

import pandas as pd
import boto3
import requests
import datetime
import sys
import logging
import sandbox.common.types.client as ctc
from sandbox.common.types.misc import DnsType
from sandbox import sdk2
from sandbox.common.errors import TemporaryError
from sandbox.projects.rasp.utils.email_notifications import EmailNotificationMixin, use_email_notification_params
from sandbox.projects.rasp.utils.juggler import JugglerNotificationMixin, use_juggler_notification_params
from sandbox.projects.rasp.utils.try_hard import try_hard
from sandbox.sandboxsdk import environments

logger = logging.getLogger()
logger.setLevel(logging.INFO)

requestDict = {}

BUCKET = 'rasp-bucket'
MDS_URL = 'https://s3.mds.yandex.net'


def getResponce(requestStr):
    if requestDict.has_key(requestStr):
        return requestDict[requestStr]
    logging.info(requestStr)
    ok = False
    tryes = 0
    res = ''
    while ok == False:
        try:
            res = requests.get(requestStr, timeout=1500).text
            ok = True
        except:
            tryes += 1
            print('error', tryes)
            sleep(2)
        if tryes > 10:
            res = requests.get(requestStr, timeout=1500).text
            ok = True

    requestDict[requestStr] = res
    return res


def getRoutes(station_from, station_to, date):
    query = 'https://www.autovokzal.org/upload/php/result.php?id=' + station_to + '&date=%27' + date + '%27&station=' + station_from
    resp = getResponce(query)
    resp = json.loads(resp)
    routes = []
    for rasp in resp['rasp']:
        if rasp['cancel'] != 'Отмена':
            routes.append(
                [rasp['rasp_id'], rasp['number_route'], rasp['name_route'], rasp['name_bus'], rasp['name_atp'],
                 rasp['price'], rasp['time_otpr'], rasp['time_prib'], date, query])
        else:
            logging.info('CANCEL:' + rasp['rasp_id'])
    routes = pd.DataFrame(routes)
    if routes.shape[0] > 0:
        routes.columns = ['id', 'number', 'name', 'vehicle', 'carrier', 'price', 'departure', 'arrival', 'date',
                          'query']
    return routes


def getThread(station_from, thread_id, time):
    query = 'https://www.autovokzal.org/upload/php/info.php?rasp_id=' + thread_id + '&time=%27' + time + ':00%27&station=' + station_from
    # print query
    resp = getResponce(query)
    resp = json.loads(resp)
    stops = []
    stops.append([stationsName[station_from], 0, '', time])
    for stop in resp['info']:
        stops.append([stop['name_station'], stop['price'], stop['time_prib'], ''])
    stops = pd.DataFrame(stops)
    stops.columns = ['stop', 'price', 'arrival', 'departure']
    return stops


def addThread(key, thread_collection):
    global threads
    global ET
    global vehicles_keys
    global carriers_keys
    global station_keys
    global stationsName

    # среди всех ниток выберем самую длинную
    main_stops_list = []
    main_key = ''
    for thread_key in thread_collection.keys():
        stops_list = getThread(thread_key, key, thread_collection[thread_key]['departure'])
        if len(stops_list) > len(main_stops_list):
            main_key = thread_key
            main_stops_list = stops_list

    # добавим в остановки времена отправления с начальных
    for thread_key in thread_collection.keys():
        first_stop_name = stationsName[thread_key]
        for n in range(0, main_stops_list.shape[0]):
            if main_stops_list.ix[n, 'stop'] == stationsName[thread_key]:
                main_stops_list.ix[n, 'departure'] = thread_collection[thread_key]['departure']
                # если по станции отправление раньше прибытия - то при импорте добавляются сутки. фиксим это
                if (main_stops_list.ix[n, 'arrival'] != "") and (
                        main_stops_list.ix[n, 'arrival'] > main_stops_list.ix[n, 'departure']):
                    print('uups', main_stops_list.ix[n, 'departure'], main_stops_list.ix[n, 'arrival'])

    thread_data = thread_collection[main_key]
    thread = ET.SubElement(threads, 'thread')
    carrier = thread_data['carrier']
    vehicle = thread_data['vehicle']
    thread.set('title', thread_data['name'])
    thread.set('t_type', 'bus')
    thread.set('number', thread_data['number'])
    thread.set('carrier_code', carrier)
    thread.set('carrier_title', carrier)
    thread.set('vehicle_code', vehicle)
    thread.set('vehicle_title', vehicle)

    vehicles_keys[vehicle] = vehicle
    carriers_keys[carrier] = carrier

    stops_list = getThread(main_key, key, thread_data['departure'])
    stations = ET.SubElement(thread, 'stoppoints')

    for m in range(0, main_stops_list.shape[0]):
        station = ET.SubElement(stations, 'stoppoint')
        station.set('station_title', main_stops_list.ix[m, 'stop'])
        station.set('station_code', main_stops_list.ix[m, 'stop'])
        station.set('arrival_time', main_stops_list.ix[m, 'arrival'])
        station.set('departure_time', main_stops_list.ix[m, 'departure'])

        station_keys[main_stops_list.ix[m, 'stop']] = main_stops_list.ix[m, 'stop']

    sch_ = ET.SubElement(thread, 'schedules')
    for date in thread_data['dates']:
        sch = ET.SubElement(sch_, 'schedule')
        sch.set('days', date)


def getDatesRange():
    result = []
    for n in range(1, 15):
        a = (datetime.datetime.today() + timedelta(days=n)).strftime("%Y-%m-%d")
        result.append(a)
    return result


def _upload(access_key_id, secret_access_key, data, key, bucket=BUCKET):
    print(access_key_id)
    print(secret_access_key)
    session = boto3.session.Session(
        aws_access_key_id=access_key_id,
        aws_secret_access_key=secret_access_key,
    )

    client = session.client(
        service_name='s3',
        endpoint_url='https://s3.mds.yandex.net',
    )

    client.put_object(
        Bucket=bucket,
        Key=key,
        Body=data)
    logging.info('File uploaded, url is {}/{}/{}'.format(MDS_URL, BUCKET, key))


def getSearchSegments_():
    segments = [
        {'from': 'zar', 'to': '5'},  # Заречный - Екатеринбург
    ]
    return segments


def getSearchSegments():
    segments = [{'from': 'ekb', 'to': '33'},  # Екатеринбург - Белоярский
                {'from': 'asb', 'to': '230'},  # Асбест  - Сухой лог
                {'from': 'asb', 'to': '33'},  # Асбест  - Белоярский
                {'from': 'ref', 'to': '133'},  # Рефтинский - Асбест

                {'from': 'ekb', 'to': '143'},  # Екатеринбург - Заречный

                {'from': 'zar', 'to': '5'},  # Заречный - Екатеринбург
                {'from': 'zar', 'to': '27'},  # Заречный - Екатеринбург сев
                {'from': 'zar', 'to': '33'},  # Заречный - Белоярский

                {'from': 'ekb', 'to': '39'},  # Екатеринбург - Богданович (Белоярский-Богданович - баг на сайте АВ)

                {'from': 'bel', 'to': '5'},  # Белоярский    - Екб
                {'from': 'bel', 'to': '27'},  # Белоярский    - Екб Северный
                {'from': 'bel', 'to': '133'},  # Белоярский - Асбест
                {'from': 'bel', 'to': '158'},  # Белоярский    - Каменск-Уральский
                {'from': 'bel', 'to': '230'},  # Белоярский - Сухой лог
                {'from': 'bel', 'to': '143'},  # Белоярский - Заречный
                {'from': 'bel', 'to': '167'},  # Белоярский - Некрасово
                {'from': 'bel', 'to': '284'},  # Белоярский - Камышево
                {'from': 'bel', 'to': '281'},  # Белоярский - Совхозный

                {'from': 'bog', 'to': '33'},  # Богданович   - Белоярский
                {'from': 'bog', 'to': '230'},  # Богданович   - Сухой Лог
                {'from': 'bog', 'to': '46'},  # Богданович   - Камышлов
                {'from': 'bog', 'to': '158'},  # Богданович   - Каменск-Уральский
                {'from': 'bog', 'to': '435'},  # Богданович   - кунарское 2
                {'from': 'bog', 'to': '432'},  # Богданович   - Гарашкинское
                {'from': 'bog', 'to': '433'},  # Богданович   - тыгиш
                {'from': 'bog', 'to': '1214'},  # Богданович   - Суворы
                {'from': 'bog', 'to': '407'},  # Богданович   - Ильинское

                {'from': 'kam', 'to': '230'},  # Камышлов  - Сухой лог
                {'from': 'kam', 'to': '33'},  # Камышлов  - Белоярский
                {'from': 'kam', 'to': '325'},  # Камышлов  - Першата
                {'from': 'kam', 'to': '262'},  # Камышлов  - нагибина
                {'from': 'kam', 'to': '314'},  # Камышлов  - Восточный
                {'from': 'kam', 'to': '251'},  # Камышлов  - Тюмень
                {'from': 'kam', 'to': '39'},  # Камышлов  - Богданович
                {'from': 'kam', 'to': '54'},  # Камышлов  - Талица

                {'from': 'irb', 'to': '5'},  # Ирбит    - Екб
                {'from': 'ekb', 'to': '111'},  # Екб    - Ирбит

                {'from': 'irb', 'to': '27'},  # Ирбит    - Екб Северный
                {'from': 'irb', 'to': '6'},  # Ирбит    - Н. Тагил
                {'from': 'irb', 'to': '524'},  # Ирбит    - Туринск
                {'from': 'irb', 'to': '189'},  # Ирбит    - Туринская слобода

                {'from': 'irb', 'to': '465'},  # Ирбит    - Лопатково
                {'from': 'irb', 'to': '482'},  # Ирбит    - Рудное
                {'from': 'irb', 'to': '499'},  # Ирбит    - реж
                {'from': 'irb', 'to': '1499'},  # Ирбит    - Кирга
                {'from': 'irb', 'to': '196'},  # Ирбит    - Байкалово
                {'from': 'irb', 'to': '54'},  # Ирбит    - Талица
                {'from': 'irb', 'to': '472'},  # Ирбит    - Прядеина
                {'from': 'irb', 'to': '503'},  # Ирбит    - Артемовский

                {'from': 'tal', 'to': '55'},  # Талица    - Бутка
                {'from': 'tal', 'to': '46'},  # Талица    - камышлов
                {'from': 'tal', 'to': '634'},  # Талица    - Калиновка
                {'from': 'tal', 'to': '646'},  # Талица    - Катарач
                {'from': 'tal', 'to': '111'},  # Талица    - Ирбит
                {'from': 'tal', 'to': '251'},  # Талица    - Тюмень
                {'from': 'tal', 'to': '668'},  # Талица    - Тюмень  ЖДВ
                {'from': 'tal', 'to': '652'},  # Талица    - Антонова
                {'from': 'tal', 'to': '624'},  # Талица    - Кокуй
                {'from': 'tal', 'to': '1218'},  # Талица    - Красногорка
                {'from': 'tal', 'to': '612'},  # Талица    - Кузнецовский
                {'from': 'tal', 'to': '615'},  # Талица    - Куяровское
                {'from': 'tal', 'to': '1215'},  # Талица    - Буткинское озеро

                {'from': 'byt', 'to': '54'},  # Бутка - Талица
                {'from': 'byt', 'to': '634'},  # Бутка - Калиновка
                {'from': 'byt', 'to': '646'},  # Бутка - Катарач

                {'from': 'ekb', 'to': '590'},  # Екатеринбург - алапаевск
                {'from': 'alap', 'to': '5'},  # Алапаевск - екатеринбург
                {'from': 'alap', 'to': '27'},  # Алапаевск - екатеринбург сев
                {'from': 'alap', 'to': '111'},  # Алапаевск - ирбит
                {'from': 'alap', 'to': '6'},  # Алапаевск - н. тагил
                {'from': 'alap', 'to': '692'},  # Алапаевск - невьянское - ключи

                {'from': 'ts', 'to': '196'},  # Туринская слобода - Байкалово - екб
                {'from': 'ts', 'to': '111'},  # Туринская слобода - Ирбит
                {'from': 'ts', 'to': '524'},  # Туринская слобода - Туринск
                {'from': 'ts', 'to': '251'},  # Туринская слобода - Тюмень
                {'from': 'ts', 'to': '719'},  # Туринская слобода - Барбашина
                {'from': 'ts', 'to': '729'},  # Туринская слобода - Ермакова
                {'from': 'ts', 'to': '564'},  # Туринская слобода - Липчинское
                {'from': 'ts', 'to': '731'},  # Туринская слобода - макуй
                {'from': 'ts', 'to': '733'},  # Туринская слобода - сагай
                {'from': 'ts', 'to': '722'},  # Туринская слобода - Юрты

                {'from': 'ekb', 'to': '1545'},  # Екатеринбург - Сысерть
                {'from': 'ekb', 'to': '1438'},  # Екатеринбург - Дегтярск
                {'from': 'ekb', 'to': '1434'},  # Екатеринбург - Полевской
                {'from': 'ekb', 'to': '62'},  # Екатеринбург - пов Ревда
                {'from': 'ekb', 'to': '69'},  # Екатеринбург - пов Бисерть
                {'from': 'ekb', 'to': '1610'},  # Екатеринбург - Двуреченск

                {'from': 'ns', 'to': '1019'},  # Нижние Серги - Атиг
                {'from': 'ns', 'to': '968'},  # Нижние Серги - пов на Атиг
                {'from': 'ns', 'to': '1247'},  # Нижние Серги - Нязепетровск
                {'from': 'ns', 'to': '1246'},  # Нижние Серги - Оленьи Ручьи
                {'from': 'ns', 'to': '1015'},  # Нижние Серги - Урмикеево
                {'from': 'ns', 'to': '976'},  # Нижние Серги - Михайловск

                {'from': 'mix', 'to': '967'},  # Михайловск - н Серьги
                {'from': 'mix', 'to': '987'},  # Михайловск - Тюльгаш
                {'from': 'mix', 'to': '5'},  # Михайловск - екатеринбург

                {'from': 'arti', 'to': '5'},  # Арти - Екатеринбург
                {'from': 'ekb', 'to': '913'},  # Екатеринбург - Арти
                {'from': 'arti', 'to': '83'},  # Арти - Красноуфимск
                {'from': 'arti', 'to': '818'},  # Арти - Бакийково
                {'from': 'arti', 'to': '1004'},  # Арти - курки
                {'from': 'arti', 'to': '1005'},  # Арти - М Тавра
                {'from': 'arti', 'to': '1000'},  # Арти - Усть Югуш
                {'from': 'arti', 'to': '91'},  # Арти - Манчаж

                {'from': 'krav', 'to': '5'},  # Красоуфимск АВ - Екб южный
                {'from': 'krav', 'to': '27'},  # Красоуфимск АВ - Екб северный
                {'from': 'krav', 'to': '913'},  # Красоуфимск АВ - арти
                {'from': 'ekb', 'to': '83'},  # екб - Красоуфимск АВ
                {'from': 'krav', 'to': '900'},  # Красоуфимск АВ - Первоуральск
                {'from': 'krav', 'to': '457'},  # Красоуфимск АВ - Пермь
                {'from': 'krav', 'to': '80'},  # Красоуфимск АВ - Ачит
                {'from': 'krav', 'to': '817'},  # Красоуфимск АВ - Бишково
                {'from': 'krav', 'to': '1243'},  # Красоуфимск АВ - Верхний Баяк
                {'from': 'krav', 'to': '831'},  # Красоуфимск АВ - Верхняя Ирга
                {'from': 'krav', 'to': '820'},  # Красоуфимск АВ - Ключики
                {'from': 'krav', 'to': '814'},  # Красоуфимск АВ - Крылово
                {'from': 'krav', 'to': '741'},  # Красоуфимск АВ - Натальинск
                {'from': 'krav', 'to': '860'},  # Красоуфимск АВ - Сарана
                {'from': 'krav', 'to': '1236'},  # Красоуфимск АВ - Шиловка

                {'from': 'achit', 'to': '83'},  # Ачит - Красноуфимс
                {'from': 'achit', 'to': '5'},  # Ачит - екб Южный
                {'from': 'achit', 'to': '27'},  # Ачит - екб Северный
                {'from': 'achit', 'to': '457'},  # Ачит - Пермь
                {'from': 'achit', 'to': '776'},  # Ачит - Быково
                {'from': 'achit', 'to': '809'},  # Ачит - В Арий
                {'from': 'achit', 'to': '769'},  # Ачит - В Потам
                {'from': 'achit', 'to': '783'},  # Ачит - В Тиса
                {'from': 'achit', 'to': '798'},  # Ачит - Карги
                {'from': 'achit', 'to': '768'},  # Ачит - Корзуновка
                {'from': 'achit', 'to': '773'},  # Ачит - М Ут
                {'from': 'achit', 'to': '767'},  # Ачит - Русский Потам
                {'from': 'achit', 'to': '788'},  # Ачит - Тюш
                {'from': 'achit', 'to': '795'},  # Ачит - Уфимский

                {'from': 'ekb', 'to': '226'},  # Екатеринбург - Челябинск
                {'from': 'ekb', 'to': '899'},  # Екатеринбург - Челябинск
                {'from': 'ekb', 'to': '158'},  # Екатеринбург - КаменскУральский
                {'from': 'ekb', 'to': '1517'},  # Екатеринбург - Касли/Кыштым
                {'from': 'ekb', 'to': '909'},  # Екатеринбург - Златоуст

                {'from': 'ekb', 'to': '294'},  # Екатеринбург - Невьянск
                {'from': 'ekb', 'to': '6'},  # Екатеринбург - Н тагил

                {'from': 'nt', 'to': '294'},  # Н тагил - Невьянск
                {'from': 'nt', 'to': '304'},  # Н тагил - В Салда
                {'from': 'nt', 'to': '1202'},  # Н тагил - В Тура
                {'from': 'nt', 'to': '1403'},  # Н тагил - Горноуральский
                {'from': 'nt', 'to': '590'},  # Н тагил - Алапаевск
                {'from': 'nt', 'to': '457'},  # Н тагил - пермь
                {'from': 'nt', 'to': '1419'},  # Н тагил - Свободный
                {'from': 'nt', 'to': '1371'},  # Н тагил - Горбуново

                {'from': 'nev', 'to': '27'},  # невьянск - екб Сев
                {'from': 'nev', 'to': '5'},  # невьянск - екб юж
                {'from': 'nev', 'to': '6'},  # невьянск - Н тагил

                {'from': 'vs', 'to': '6'},  # В салда - Н тагил
                {'from': 'vs', 'to': '1173'},  # В салда - Н Салда

                {'from': 'ser', 'to': '293'},  # Серов - Н Ляля
                {'from': 'ser', 'to': '287'},  # Серов - Краснотурьинск
                {'from': 'ser', 'to': '1099'},  # Серов - Сосьва

                ]

    return segments


def get_and_load(access_key_id, secret_access_key):
    global stationsName
    global threads
    global station_keys
    global vehicles_keys
    global carriers_keys

    channel = ET.Element('channel')
    channel.set('version', '1.0')
    channel.set('t_type', 'bus')
    channel.set('station_code_system', 'vendor')
    channel.set('timezone', 'local')
    channel.set('carrier_code_system', 'vendor')
    channel.set('carrier_code_system', 'vendor')
    channel.set('vehicle_code_system', 'vendor')

    group = ET.SubElement(channel, 'group')
    group.set('code', 'ekb')

    stations_dict = ET.SubElement(group, 'stations')
    station_keys = {}
    vehicles_dict = ET.SubElement(group, 'vehicles')
    vehicles_keys = {}
    carriers_dict = ET.SubElement(group, 'carriers')
    carriers_keys = {}
    threads = ET.SubElement(group, 'threads')

    dates = getDatesRange()
    segments = getSearchSegments()

    stationsName = {'ekb': u'г.Екатеринбург АВ /Южный/', 'bel': u'р.п.Белоярский АС', 'asb': u'г.Асбест АВ',
                    'bog': u'г.Богданович АС', 'kam': u'г.Камышлов АВ', 'irb': u'г.Ирбит АС', 'tal': u'г.Талица АС',
                    'byt': u'с.Бутка ППБ', 'zar': u'г.Заречный АС', 'ref': u'п.Рефтинский АС',
                    'alap': u'г.Алапаевск АС', 'ts': u'с.Туринская Слобода АС', 'ns': u'г.Нижние Серги АС',
                    'mix': u'г.Михайловск ППБ', 'arti': u'р.п.Арти АС', 'krav': u'г.Красноуфимск АВ',
                    'achit': u'р.п.Ачит АС',
                    'nev': u'г.Невьянск ППБ', 'nt': u'г.Нижний Тагил АВ', 'vs': u'г.Верхняя Салда ППБ',
                    'ser': u'г.Серов АС'}

    threads_dict = {}
    for segment in segments:
        station_from = segment['from']
        station_keys[station_from] = stationsName[station_from]
        for req_date in dates:
            routes = getRoutes(station_from, segment['to'], req_date)
            for n in range(0, routes.shape[0]):
                thread_id = routes.ix[n, 'id']
                if threads_dict.has_key(thread_id) == False:
                    threads_dict[thread_id] = {}

                if threads_dict[thread_id].has_key(station_from) == False:
                    threads_dict[thread_id][station_from] = {'number': routes.ix[n, 'number'],
                                                             'name': routes.ix[n, 'name'],
                                                             'vehicle': routes.ix[n, 'vehicle'],
                                                             'carrier': routes.ix[n, 'carrier'],
                                                             'price': routes.ix[n, 'price'],
                                                             'departure': routes.ix[n, 'departure'],
                                                             'dates': [routes.ix[n, 'date']], 'id': thread_id,
                                                             'query': routes.ix[n, 'query']}
                else:
                    threads_dict[thread_id][station_from]['dates'].append(req_date)

    for key in threads_dict.keys():
        addThread(key, threads_dict[key])

    for key in station_keys.keys():
        station = ET.SubElement(stations_dict, 'station')
        station.set('code', key)
        station.set('title', key)
    for key in vehicles_keys.keys():
        vehicle = ET.SubElement(vehicles_dict, 'vehicle')
        vehicle.set('code', key)
        vehicle.set('title', key)
    for key in carriers_keys.keys():
        carrier = ET.SubElement(carriers_dict, 'carrier')
        carrier.set('code', key)
        carrier.set('title', key)

    tree = ET.ElementTree(channel)
    with open('tst.xml', "w") as fh:
        tree.write(fh, encoding='utf8')

    f = open('tst.xml')
    result = _upload(access_key_id, secret_access_key, f.read(), 'buses/ekb_south2.xml')


class SouthBusStationParser_2(sdk2.Task, EmailNotificationMixin, JugglerNotificationMixin):
    class Requirements(sdk2.Task.Requirements):
        # client_tags = ctc.Tag.LXC
        ram = 2 * 1024
        dns = DnsType.DNS64
        # environments = [
        #     environments.PipEnvironment('python-statface-client', use_wheel=False),
        #     environments.PipEnvironment('psycopg2-binary')
        # ]

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 3600

        with sdk2.parameters.Group('MDS parameters') as mds_block:
            vault_owner = sdk2.parameters.String('Vault owner name', required=True)
            mds_access_key_id_vault = sdk2.parameters.String(
                'Vault name: access_key_id', required=True, default='{mds_access_key_id}'
            )
            mds_access_secret_key_vault = sdk2.parameters.String(
                'Vault name: access_secret_key', required=True, default='{mds_access_secret_key}'
            )

        _email_notification_params = use_email_notification_params()
        _juggler_notification_params = use_juggler_notification_params()

    def on_execute(self):
        logging.info('BLABLABLA_new3')
        value_owner = self.Parameters.vault_owner
        logging.info(value_owner)
        aws_access_key_id = sdk2.Vault.data(self.Parameters.vault_owner, self.Parameters.mds_access_key_id_vault)
        aws_secret_access_key = sdk2.Vault.data(self.Parameters.vault_owner, self.Parameters.mds_access_secret_key_vault)
        logging.info(aws_access_key_id)
        get_and_load(aws_access_key_id, aws_secret_access_key)
        logging.info('DONE')

    def on_save(self):
        super(SouthBusStationParser_2, self).on_save()
        self.add_email_notifications()
