# coding=utf-8
import logging
from sandbox import sdk2
from sandbox.projects.rasp.utils.email_notifications import EmailNotificationMixin, use_email_notification_params

logger = logging.getLogger()
logger.setLevel(logging.INFO)


class rzdParser(sdk2.Task, EmailNotificationMixin):
    class Requirements(sdk2.Task.Requirements):
        # client_tags = ctc.Tag.LXC
        cores = 1
        ram = 2 * 1024
        # res id
        tasks_resource = sdk2.Task.Requirements.tasks_resource(default=1732669735)

        class Caches(sdk2.Requirements.Caches):  # enable multislot https://wiki.yandex-team.ru/sandbox/clients/#client-tags-multislot
            pass  # means that task do not use any shared caches

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 3600

        with sdk2.parameters.Group('secret parameters') as mds_block:
            vault_owner = sdk2.parameters.String('Vault owner name', required=True)
            mds_access_key_id_vault = sdk2.parameters.String(
                'Vault name: access_key_id', required=True, default='mds_access_key_id'
            )
            mds_access_secret_key_vault = sdk2.parameters.String(
                'Vault name: access_secret_key', required=True, default='mds_access_secret_key'
            )
            rzd_mysql_login_vault = sdk2.parameters.String(
                'Vault name: rzd_mysql_login', required=True, default='rzd_mysql_login'
            )
            rzd_mysql_password_vault = sdk2.parameters.String(
                'Vault name: rzd_mysql_password', required=True, default='rzd_mysql_password'
            )
            new_g_mode = sdk2.parameters.String(
                'new_g_mode', required=True, default='g20'
            )

        _email_notification_params = use_email_notification_params()

    def on_execute(self):
        logging.info('RZD parser start')
        logging.info('build by 2020-11-17')
        from travel.rasp.content.rzdParser.main import MainModule
        aws_access_key_id = sdk2.Vault.data(self.Parameters.vault_owner, self.Parameters.mds_access_key_id_vault)
        aws_secret_access_key = sdk2.Vault.data(
            self.Parameters.vault_owner, self.Parameters.mds_access_secret_key_vault
        )
        mysql_login = sdk2.Vault.data(self.Parameters.vault_owner, self.Parameters.rzd_mysql_login_vault)
        mysql_password = sdk2.Vault.data(self.Parameters.vault_owner, self.Parameters.rzd_mysql_password_vault)
        if self.Parameters.new_g_mode == 'g21':
            new_g = True
        else:
            new_g = False
        mm = MainModule(mysql_login, mysql_password, aws_access_key_id, aws_secret_access_key, True, new_g)
        mm.start()
        logging.info('DONE')

    def on_save(self):
        super(rzdParser, self).on_save()
        self.add_email_notifications()
