# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from sandbox import sdk2
from sandbox.projects.rasp.utils.email_notifications import EmailNotificationMixin, use_email_notification_params


class RaspExampleFailTask(sdk2.Task, EmailNotificationMixin):
    """Example fail task"""
    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 3600

        notifications = []
        _email_notification_params = use_email_notification_params()

    def on_save(self):
        super(RaspExampleFailTask, self).on_save()
        self.add_email_notifications()

    def on_execute(self):
        raise Exception("Fail...")
