# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging

from sandbox.common import errors
from sandbox import sdk2
from sandbox.common.types.task import Status
from sandbox.projects.rasp.examples.rasp_example_fail_task import RaspExampleFailTask
from sandbox.projects.rasp.utils.email_notifications import EmailNotificationMixin, use_email_notification_params


class RaspExampleRunChild(sdk2.Task, EmailNotificationMixin):
    """Example run child task"""
    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 3600

        notifications = []
        _email_notification_params = use_email_notification_params()

    def on_save(self):
        super(RaspExampleRunChild, self).on_save()
        self.add_email_notifications()

    def on_execute(self):
        logging.info(
            "on_execute id=%d parent_id=%d notifications=%r",
            self.id,
            self.parent.id if self.parent else None,
            self.Parameters.notifications
        )
        sub_task_id = self.Context.sub_task_id
        if not sub_task_id:
            child_task = RaspExampleFailTask(
                self,
                owner=self.Parameters.owner,
                description='',
                priority=self.Parameters.priority,
                enable_email_notifications=False
            )
            child_task.enqueue()
            logging.info(
                "create subtask child_task_id=%d",
                child_task.id,
            )
            self.Context.sub_task_id = child_task.id

            raise sdk2.WaitTask(
                [child_task],
                Status.Group.FINISH | Status.Group.BREAK,
                wait_all=True,
            )
        child_task = sdk2.Task.find(id=sub_task_id).first()
        logging.info(
            "child task status=%s",
            child_task.status,
        )
        if child_task.status != Status.SUCCESS:
            raise errors.TaskFailure("Child task is fail")
