import logging

from datetime import datetime

from sandbox.projects.rasp.qloud.UpdateResources import RaspQloudUpdateResources
from sandbox import sdk2


log = logging.getLogger(__name__)
log.setLevel(logging.INFO)


class UpdateQloudMixin(object):
    def upload_qloud_environments(self, environments=None, resources=None, variables=None, description=None):
        if not resources and not variables:
            raise ValueError('No resources and variables to update')

        environments = environments or self.Parameters.qloud_environments
        variables = variables or {}
        variables.update({'REBUILD_RESOURCES_DOWNTIME_FIX': str(datetime.now())})

        for qloud_environment in environments:
            log.info('Updating qloud environment {}', qloud_environment)

            task = RaspQloudUpdateResources(
                self,
                owner=self.Parameters.owner,
                priority=self.Parameters.priority,
                description=description or 'Update qloud environment {} from Sandbox task {}'
                    .format(qloud_environment, self.id),

                token_owner=self.Parameters.qloud_resource_updater__token_owner,
                token_name=self.Parameters.qloud_resource_updater__token_name,

                resources=resources,
                variables=variables,
                qloud_environment=qloud_environment,

                enable_email_notifications=False
            )

            task.enqueue()


def update_qloud_params():
    class _UpdateQloudParameters(sdk2.Parameters):
        with sdk2.parameters.Group('Qloud parameters') as qloud_block:
            qloud_resource_updater__token_name = sdk2.parameters.String(
                'Qloud token vault', required=True, default='rasp-qloud-oauth'
            )

            qloud_resource_updater__token_owner = sdk2.parameters.String(
                'Qloud token owner name', required=True, default='RASP'
            )

            qloud_environments = sdk2.parameters.List(
                'Qloud environment names',
                required=True
            )

    return _UpdateQloudParameters()
