# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging

from sandbox import sdk2
import sandbox.common.types.misc as ctm
from sandbox.projects.common import binary_task
from sandbox.projects.rasp.utils.email_notifications import EmailNotificationMixin, use_email_notification_params
from sandbox.projects.rasp.utils.juggler import JugglerNotificationMixin, use_juggler_notification_params
from sandbox.projects.rasp.utils.rasp_scripts import RaspScriptsTask, use_rasp_scripts_params

log = logging.getLogger()
log.setLevel(logging.INFO)


class RaspCheckAeroexBalanceTask(
    binary_task.LastBinaryTaskRelease,
    sdk2.Task,
    EmailNotificationMixin,
    JugglerNotificationMixin,
    RaspScriptsTask
):
    class Requirements(sdk2.Task.Requirements):
        cores = 1
        ram = 1 * 1024
        dns = ctm.DnsType.DNS64

        class Caches(sdk2.Requirements.Caches):  # enable multislot https://wiki.yandex-team.ru/sandbox/clients/#client-tags-multislot
            pass  # means that task do not use any shared caches

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 60 * 3

        ext_params = binary_task.binary_release_parameters(stable=True)
        _rasp_scripts_params = use_rasp_scripts_params()
        _email_notification_params = use_email_notification_params()
        _juggler_notification_params = use_juggler_notification_params()

    def on_save(self):
        binary_task.LastBinaryTaskRelease.on_save(self)
        self.add_email_notifications()
        self.add_juggler_notifications(environment=self.Parameters.env_type)

    def on_execute(self):
        binary_task.LastBinaryTaskRelease.on_execute(self)

        self.set_common_environ()
        from travel.rasp.suburban_selling.manual_scripts.check_balance import check

        try:
            status = check()
        except Exception as ex:
            status = repr(ex)
            raise
        finally:
            log.info(status)
            self.Context.status = status
