# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging

from sandbox import sdk2
from sandbox.projects.common import binary_task
from sandbox.projects.common.ya_deploy import release_integration
from sandbox.projects.rasp.rasp_scripts.RaspScriptsUpdateQloud import RaspScriptsUpdateQloudMixin
from sandbox.projects.rasp.resource_types import RaspPathfinderMapsNearestSettlement
from sandbox.projects.rasp.utils.email_notifications import EmailNotificationMixin, use_email_notification_params
from sandbox.projects.rasp.utils.juggler import JugglerNotificationMixin, use_juggler_notification_params
from sandbox.projects.rasp.utils.rasp_scripts import RaspScriptsTask, use_rasp_scripts_params

logger = logging.getLogger()
logger.setLevel(logging.INFO)


LOCAL_PATHFINDER_MAPS_NEAREST_SETTLEMENT_PATH = 'pathfinder_maps_nearest_settlement.bin'


class RaspPathfinderMapsNearestSettlementTask(
    release_integration.ReleaseToYaDeployTask2,
    binary_task.LastBinaryTaskRelease,
    sdk2.Task,
    EmailNotificationMixin,
    JugglerNotificationMixin,
    RaspScriptsTask,
    RaspScriptsUpdateQloudMixin
):
    class Requirements(sdk2.Task.Requirements):
        cores = 1
        ram = 10 * 1024

        class Caches(sdk2.Requirements.Caches):  # enable multislot https://wiki.yandex-team.ru/sandbox/clients/#client-tags-multislot
            pass  # means that task do not use any shared caches

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 3600 * 10

        ext_params = binary_task.binary_release_parameters(stable=True)

        with sdk2.parameters.Group('General') as general:
            update_env_type = sdk2.parameters.String('Update env type', required=True, default='testing')
            qloud_resource_updater__token_owner = sdk2.parameters.String('Token owner', required=True, default='RASP')
            qloud_resource_updater__token_name = sdk2.parameters.String('Token name', required=True, default='rasp-qloud-oauth')

        _rasp_scripts_params = use_rasp_scripts_params()
        _email_notification_params = use_email_notification_params()
        _juggler_notification_params = use_juggler_notification_params()

    def _run_pathfinder_maps_nearest_settlements(self):
        from travel.rasp.rasp_scripts.scripts.gen_pathfinder_maps_nearest_settlements import run
        run()

    def on_save(self):
        binary_task.LastBinaryTaskRelease.on_save(self)
        self.add_email_notifications()
        self.add_juggler_notifications(environment=self.Parameters.env_type)

    def on_execute(self):
        binary_task.LastBinaryTaskRelease.on_execute(self)

        self.set_common_environ()

        self._run_pathfinder_maps_nearest_settlements()
        self._upload_resource(RaspPathfinderMapsNearestSettlement, LOCAL_PATHFINDER_MAPS_NEAREST_SETTLEMENT_PATH)
