from datetime import datetime

from sandbox.projects.rasp.qloud.UpdateResources import RaspQloudUpdateResources
from sandbox import sdk2


class RaspScriptsUpdateQloudMixin(object):
    def _get_path(self, resource):
        resource_data = sdk2.ResourceData(resource)
        return resource_data.path.as_posix()

    def _get_resource_path(self, resource_class, params):
        count = resource_class.find(**params).count
        resource = resource_class.find(**params).order(resource_class.id).offset(count - 1).first()
        return self._get_path(resource)

    def _upload_qloud_environment(self, environments, path, description):
        resource_id = getattr(self.Context, 'resource_{}_id'.format(path))
        resources = sdk2.Resource.find(id=resource_id).limit(1)

        variables = {'REBUILD_RESOURCES_DOWNTIME_FIX': str(datetime.now())}

        tasks = [
            RaspQloudUpdateResources(
                self,
                owner=self.Parameters.owner,
                priority=self.Parameters.priority,
                description=description,

                token_owner=self.Parameters.qloud_resource_updater__token_owner,
                token_name=self.Parameters.qloud_resource_updater__token_name,

                resources=resources,
                variables=variables,
                qloud_environment=qloud_environment,

                enable_email_notifications=False
            )
            for qloud_environment in environments.get(self.Parameters.update_env_type, ())
        ]

        for t in tasks:
            t.enqueue()

    def _upload_resource(self, resource_type, path):
        resource = resource_type(self, description=path, path=path)
        resource_data = sdk2.ResourceData(resource)
        resource_data.ready()

        setattr(self.Context, 'resource_{}_id'.format(path), resource.id)
