# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from sandbox import sdk2

from sandbox.projects.rasp.resource_types.release_machine import *  # noqa


class RaspGeometryTesting(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = ['RASP']


class RaspGeometryProduction(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = ['RASP']


class RaspPathfinderTesting(sdk2.Resource):
    auto_backup = True


class RaspPathfinderProduction(sdk2.Resource):
    auto_backup = True


class RaspPathfinderCoreTesting(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = ['RASP']


class RaspPathfinderCoreProduction(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = ['RASP']


#  railway_map resource https://a.yandex-team.ru/arc/trunk/arcadia/travel/rasp/pathfinder/railway_map
class RaspMifFiles(sdk2.Resource):
    auto_backup = True


class RaspDBDumpResource(sdk2.Resource):
    auto_backup = True
    environment = sdk2.Attributes.String('Environment')
    releasable = True
    releasers = ['RASP']


class RaspMysqlSchemaDump(sdk2.Resource):
    auto_backup = True
    environment = sdk2.Attributes.String('environment')
    original_name = sdk2.Attributes.String('original_name')


class RaspMysqlDBDump(sdk2.Resource):
    auto_backup = True
    ttl = 90
    db_type = sdk2.Attributes.String('db_type')
    environment = sdk2.Attributes.String('environment')
    original_name = sdk2.Attributes.String('original_name')


class DumpRaspDataResource(sdk2.Resource):
    releasable = True
    auto_backup = True
    ttl = 'inf'
    build_type = sdk2.parameters.String("Build type")
    platform = sdk2.parameters.String("Platform")
    resource_name = sdk2.parameters.String("Resource name")
    resource_version = sdk2.parameters.String("Resource version")
    environment = sdk2.Attributes.String("Environment type")


class DumpTrainDataResource(sdk2.Resource):
    releasable = True
    auto_backup = True
    ttl = 'inf'
    build_type = sdk2.Attributes.String("Build type")
    resource_name = sdk2.Attributes.String("Resource name", required=True)
    environment = sdk2.Attributes.String("Environment type")


class RaspMordaMarkup(sdk2.Resource):
    releasable = True
    auto_backup = True
    ttl = 'inf'


class RaspTouchMarkup(sdk2.Resource):
    releasable = True
    auto_backup = True
    ttl = 'inf'


class RaspAdminMarkup(sdk2.Resource):
    releasable = True
    auto_backup = True
    ttl = 'inf'


class RaspAdminStatic(sdk2.Resource):
    releasable = True
    auto_backup = True
    ttl = 'inf'


class RaspPathfinderRailway(sdk2.Resource):
    releasable = True
    auto_backup = True
    ttl = 'inf'


class RaspPreparedThreads(sdk2.Resource):
    releasable = True
    auto_backup = True
    ttl = 'inf'


class RaspPathfinderMapsNearestSettlement(sdk2.Resource):
    releasable = True
    releasers = ['RASP']
    auto_backup = True
    ttl = 'inf'


class RaspBanditResource(sdk2.Resource):
    releasable = True
    auto_backup = True
    ttl = 'inf'
    build_type = sdk2.parameters.String("Build type")
    resource_name = sdk2.Attributes.String("Resource name")
    resource_version = sdk2.parameters.String("Resource version")
    platform = sdk2.parameters.String("Platform")
    environment = sdk2.Attributes.String("Environment type")


class MessagePackResource(sdk2.Resource):
    pass


class RaspSuggestsObjsDataResource(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = ['RASP']


class RaspSuggestsIdConverterResource(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = ['RASP']


class MovistaBillingCompareTesting(sdk2.Resource):
    auto_backup = True


class MovistaBillingCompareProduction(sdk2.Resource):
    auto_backup = True


class ImBillingCompareTesting(sdk2.Resource):
    auto_backup = True


class ImBillingCompareProduction(sdk2.Resource):
    auto_backup = True


class RaspMaintenanceConf(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = ['RASP']


class TrainCrossLinksErrorsTesting(sdk2.Resource):
    auto_backup = True


class TrainCrossLinksErrorsProduction(sdk2.Resource):
    auto_backup = True
