# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function
import logging

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess


def generate_changelog(qloud_oauth_owner, qloud_oauth_name, components, last_version_environment_name,
                       version_tag_mark_params, checkout_path):
    try:
        current_production_version_tag = get_current_production_version(
            qloud_oauth_owner,
            qloud_oauth_name,
            components,
            last_version_environment_name
        )
        versions_filter = '--start-from={}'.format(current_production_version_tag)
    except Exception as ex:
        logging.exception('Failed to get latest production version, because of %s', repr(ex))
        versions_filter = '--max-versions=15'
    with sdk2.helpers.ProcessLog(logger='gen-changelog') as pl:
        return subprocess.check_output(
            ['./deploy_tools/versions.py', 'changelog', versions_filter] + version_tag_mark_params,
            cwd=checkout_path, timeout=120, stderr=pl.stderr).strip()


def get_current_production_version(qloud_oauth_owner, qloud_oauth_name, components, last_version_environment_name):
    from projects.rasp.qloud.api import QloudPublicApi, ComponentSpecification
    qloud_api = QloudPublicApi(token=sdk2.Vault.data(
        qloud_oauth_owner,
        qloud_oauth_name
    ))
    component_path = components[0]
    component_spec = ComponentSpecification.parse_from_path(component_path)
    production_component_spec = component_spec.with_environment(last_version_environment_name)
    environment = qloud_api.dump_environment(production_component_spec.environment_id)
    component_names = [cp.split('.')[-1] for cp in components]
    for component in environment['components']:
        logging.info(component['componentName'])
        if '*' in component_names or component['componentName'] in component_names:
            repository = component['properties']['repository']
            break
    _, version = repository.split(':')
    return version
