# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging
import os
from typing import AnyStr, Union

from sandbox import sdk2


log = logging.getLogger(__name__)
log.setLevel(logging.INFO)


def use_geobase_params():
    class _GeobaseParams(sdk2.Parameters):
        with sdk2.parameters.Group('Geobase parameters') as rasp_geobase_params:
            geobase_folder = sdk2.parameters.String('Geobase extract folder', required=True, default='geobase')

    return _GeobaseParams()


class GeobaseMixin:
    GEOBASE_FILENAME = 'geodata4.bin'

    @property
    def geobase_path(self):
        # type: (Union[sdk2.Task, GeobaseMixin]) -> AnyStr
        return os.path.abspath(os.path.join(self.Parameters.geobase_folder, self.GEOBASE_FILENAME))

    def download_geobase(self):
        # type: (Union[sdk2.Task, GeobaseMixin]) -> None
        sdk2.paths.make_folder(self.Parameters.geobase_folder)

        geobase_resource = sdk2.Resource['GEODATA4BIN_STABLE'].find(attrs={'released': 'stable'}).first()
        if not geobase_resource:
            raise sdk2.task.common_errors.ResourceNotFound('Last stable GEODATA4BIN_STABLE is not found')

        log.info('Download geobase {}'.format(geobase_resource.id))
        geobase_resource_path = sdk2.ResourceData(geobase_resource).path.as_posix()
        sdk2.paths.fs.untar_archive(str(geobase_resource_path), self.Parameters.geobase_folder)
