# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from typing import Union, Optional

from sandbox import sdk2
from sandbox.common.types import task as ctt
from sandbox.common.types import notification as ctn


def use_juggler_notification_params():
    class _JugglerNotificationParams(sdk2.Parameters):
        with sdk2.parameters.Group('Juggler notifications parameters') as juggler_notifications_params:
            enable_juggler_notifications = sdk2.parameters.Bool(
                'Enable juggler notifications?', required=True, default=True
            )

    return _JugglerNotificationParams()


class JugglerNotificationMixin(object):
    def add_juggler_notifications(self, service=None, environment='production'):
        # type: (Union[sdk2.Task, JugglerNotificationMixin], Optional[str], str) -> None

        if not self.Parameters.enable_juggler_notifications:
            return

        owner = str(self.owner).lower()
        if not owner:
            return

        host = '{}_sandbox_{}'.format(owner, environment)
        service = service or str(self.type)
        recipient = 'host={}&service={}'.format(host, service)

        if self.Parameters.notifications is None:
            self.Parameters.notifications = []

        self.Parameters.notifications = filter(
            lambda n: n.transport != ctn.Transport.JUGGLER,
            self.Parameters.notifications
        )

        self.Parameters.notifications.extend([
            sdk2.Notification(
                [ctt.Status.NOT_RELEASED,
                 ctt.Status.FAILURE,
                 ctt.Status.EXCEPTION,
                 ctt.Status.NO_RES,
                 ctt.Status.TIMEOUT,
                 ctt.Status.EXPIRED],
                [recipient],
                ctn.Transport.JUGGLER,
                check_status=ctn.JugglerStatus.CRIT
            ),
            sdk2.Notification(
                [ctt.Status.SUCCESS],
                [recipient],
                ctn.Transport.JUGGLER,
                check_status=ctn.JugglerStatus.OK
            )
        ])
