# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging
import os

from sandbox import sdk2

log = logging.getLogger(__name__)
log.setLevel(logging.INFO)


def get_resource_ready_params():
    # чтобы не подключать sandbox/projects/common в utils
    from sandbox import common
    return {'state': common.types.resource.State.READY}


def use_rasp_scripts_params():
    class _RaspScriptsParameters(sdk2.Task.Parameters):
        with sdk2.parameters.Group('Rasp script params') as rasp_script_group:
            vault_oauth = sdk2.parameters.String('Vault oauth name', required=True, default='rasp-robot-vault-oauth')
            env_type = sdk2.parameters.String('Env type', required=True, default='production')
            db_type = sdk2.parameters.String('DB type', required=True, default='service')
            env_variables = sdk2.parameters.Dict('Task environment variables', required=False, default=dict())

    return _RaspScriptsParameters()


class RaspScriptsTask(object):
    def set_task_environ(self):
        pass

    def set_common_environ(self):
        log.info("set_common_environ start")

        for key, value in self.Parameters.env_variables.items():
            os.environ[key] = value

        from sandbox import common

        # rasp_scripts settings
        vault_oauth = sdk2.Vault.data(self.Parameters.vault_oauth)
        os.environ['RASP_VAULT_OAUTH_TOKEN'] = vault_oauth
        os.environ['RASP_GEOBASE_LAZY_LOAD'] = 'True'
        os.environ['RASP_SANDBOX_DC'] = common.config.Registry().this.dc
        os.environ['YENV_TYPE'] = self.Parameters.env_type
        os.environ['DJANGO_SETTINGS_MODULE'] = 'travel.rasp.rasp_scripts.bin.local_settings'
        os.environ['SANDBOX_CPU_GUARANTEE'] = str(self.Requirements.cores) if self.Requirements.cores else ''

        if self.Parameters.db_type == 'service':
            os.environ['RASP_SERVICE_INSTANCE'] = 'True'

        self.set_task_environ()

        # загрузили джангу, local_settings и т.д. - теперь можно запускать любой расписанческий код
        from travel.rasp.rasp_scripts.load_project import load_project
        load_project()

        log.info("set_common_environ done")
