# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging
from functools import wraps

from sandbox.common.errors import TemporaryError


def retry_task_on(exception_to_check):
    """Фабрика декораторов. Возвращает декоратор, который вызывает декорируемую функцию и если она выбросила исключение
    из указанного списка то выбрасывает TemporaryError чем вызывает перезапуск Sandbox-задачи
    """
    def decorator(f):
        @wraps(f)
        def wrapper(*args, **kwargs):
            try:
                return f(*args, **kwargs)
            except exception_to_check as e:
                logging.warning("Exception - raise Temporary", exc_info=True)
                raise TemporaryError(e)

        return wrapper

    return decorator
