# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from typing import Union

from sandbox import sdk2
from sandbox.sdk2 import yav


class SolomonProgressMixin(object):
    SOLOMON_PROJECT = 'rasp'
    SOLOMON_SERVICE = 'sandbox'
    SOLOMON_CLUSTER_BY_ENV = {
        'testing': 'sandbox_testing',
        'production': 'sandbox_production'
    }

    SOLOMON_SECRET_ID = 'sec-01cjvsaf2hrdkfdr97c30dv3t4'
    SOLOMON_SECRET_KEY = 'solomon-token'
    SOLOMON_VERSION = ''

    def _get_solomon_token(self):
        secret_data = yav.Secret(self.SOLOMON_SECRET_ID, self.SOLOMON_VERSION).data()
        return secret_data[self.SOLOMON_SECRET_KEY]

    def report_progress(self, source, environment):
        # type: (Union[sdk2.Task, SolomonProgressMixin], str, str) -> object

        labels = {
            'sensor_type': 'progress_reporter',
            'host': self.type.__name__,
            'owner': self.owner
        }

        from travel.rasp.library.python.solomon import SolomonProgressReporter
        return SolomonProgressReporter(
            solomon_url='http://solomon.yandex.net',
            source=source,
            grid_interval=5,
            labels=labels,
            project=self.SOLOMON_PROJECT,
            cluster=self.SOLOMON_CLUSTER_BY_ENV[environment],
            service=self.SOLOMON_SERVICE,
            auth_token=self._get_solomon_token()
        ).context()
