# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function
from functools import wraps
from time import sleep

TRY_HARD_NEVER_SLEEP = False


# TODO: перейти на try_hard из common
def try_hard(max_retries=5, sleep_duration=1, retriable_exceptions=None, on_exception=None):
    """
    Пример использования:
    @try_hard(max_retries=10, retriable_exceptions=(requests.HTTPError,))
    def my_fail_able_function():
        try:
            response = requests.get('https://yandex.fu')
        except requests.HTTPError:
            raise
        return True
    :param max_retries: количество попыток
    :param sleep_duration: сколько спать
    :param retriable_exceptions: список исключений, после которых возможен повтор
    :param on_exception: callable(ex, tries_left, args, kwargs) - коллбэк, вызываемый при ошибке.
                         Можно использовать, например, для логирования.
    :return:
    """
    if retriable_exceptions is None:
        retriable_exceptions = (Exception,)

    def decorator(func):
        @wraps(func)
        def wrapper(*args, **kwargs):
            for tries_left in reversed(range(max_retries)):
                try:
                    return func(*args, **kwargs)
                except retriable_exceptions as ex:
                    if on_exception:
                        on_exception(ex, tries_left, args=args, kwargs=kwargs)
                    if tries_left == 0:
                        raise
                    if not TRY_HARD_NEVER_SLEEP:
                        sleep(sleep_duration)
        return wrapper
    return decorator
