PY2_LIBRARY()

OWNER(
    g:rasp-back
)

SET(PWD "sandbox/projects/rasp")
PEERDIR(
    ${PWD}/CheckFiles
    ${PWD}/CheckRaspDataResources
    ${PWD}/DumpMysqlDb
    ${PWD}/DumpRaspData
    ${PWD}/DumpTrainData
    ${PWD}/TrainsDumpActualDirections
    ${PWD}/TrainsDumpTemplates
    ${PWD}/TrainsGenerateSitemap
    ${PWD}/TrainsGenerateCanonical
    ${PWD}/TrainsGenerateCrossLinks

    ${PWD}/analytics/RaspAeroOrdersStat
    ${PWD}/analytics/RaspBlaBlaCarReport
    ${PWD}/analytics/RaspBusPartnersStat
    ${PWD}/analytics/RaspRefundsToStat
    ${PWD}/analytics/RaspZdOrdersStat

    ${PWD}/bandit/RaspBanditProcessing

    ${PWD}/bus/BusAutoMatcher
    ${PWD}/bus/BusCarrierMatcher
    ${PWD}/bus/BusEndpointsStats
    ${PWD}/bus/BusFeedsUpdater
    ${PWD}/bus/BusOrderReport
    ${PWD}/bus/BusResetSearchResultCacheByDirection
    ${PWD}/bus/BusResetSearchResultCacheByParticularDirection
    ${PWD}/bus/BusResetSearchResultCacheByPoint
    ${PWD}/bus/BusResetSegmentCache
    ${PWD}/bus/BusResourceUpdate/BusAdminDictsUpdate
    ${PWD}/bus/BusResourceUpdate/BusEndpointsUpdate
    ${PWD}/bus/BusResourceUpdate/BusPointkeyFilterUpdate
    ${PWD}/bus/BusResourceUpdate/BusTTypeFilterUpdate
    ${PWD}/bus/BusSalesmon
    ${PWD}/bus/BusSitemap

    ${PWD}/content/SouthBusStationParser
    ${PWD}/content/rzdParser

    ${PWD}/examples/rasp_example_fail_task
    ${PWD}/examples/rasp_example_run_child

    ${PWD}/infra/GenerateAlerts
    ${PWD}/infra/UpdateAdminMarkup
    ${PWD}/infra/UpdateMordaMarkup
    ${PWD}/infra/UpdateTouchMarkup
    ${PWD}/infra/RaspAdminYaPackage
    ${PWD}/infra/RunAndRelease

    ${PWD}/marketing/ContentAdminUpdateDicts

    ${PWD}/rasp_scripts/BuildChelyabinskBusSchedule
    ${PWD}/rasp_scripts/BuildKrasnodarBusSchedule
    ${PWD}/rasp_scripts/BuildOdnakassaSchedule
    ${PWD}/rasp_scripts/CheckAeroexBalance
    ${PWD}/rasp_scripts/GenerateArchivalData
    ${PWD}/rasp_scripts/GenerateGeometry
    ${PWD}/rasp_scripts/GenerateImGroupedData
    ${PWD}/rasp_scripts/GenerateJournalSitemap
    ${PWD}/rasp_scripts/GenerateLivemap
    ${PWD}/rasp_scripts/GeneratePathfinderData
    ${PWD}/rasp_scripts/RaspAdminScriptAfterRun
    ${PWD}/rasp_scripts/RaspApiPublicStationsList
    ${PWD}/rasp_scripts/RaspCleanTemporarySchedule
    ${PWD}/rasp_scripts/RaspDeployBinaryTask
    ${PWD}/rasp_scripts/RaspDynamicPlatforms
    ${PWD}/rasp_scripts/RaspGenericTask
    ${PWD}/rasp_scripts/RaspInfocenterTask
    ${PWD}/rasp_scripts/RaspMinPrices
    ${PWD}/rasp_scripts/RaspSuburbanCompareWithBilling
    ${PWD}/rasp_scripts/RaspNearestSuburban
    ${PWD}/rasp_scripts/RaspPathfinderMapsNearestSettlement
    ${PWD}/rasp_scripts/RaspRzdTask
    ${PWD}/rasp_scripts/RaspScriptExample
    ${PWD}/rasp_scripts/RaspScriptsUpdateQloud
    ${PWD}/rasp_scripts/RaspSearchLogYtSchema
    ${PWD}/rasp_scripts/RaspSuburbanEvents
    ${PWD}/rasp_scripts/RaspSuburbanTask
    ${PWD}/rasp_scripts/RaspUpdateMaintenanceConf
    ${PWD}/rasp_scripts/suggests/SearchStat
    ${PWD}/rasp_scripts/suggests/Generate

    ${PWD}/resource_types

    ${PWD}/smoke/RunAllSmokeTests
    ${PWD}/smoke/RunSmokeTests

    sandbox/common
    sandbox/projects/BuildDockerImageFromGit
    sandbox/projects/BuildDockerImageV6
    sandbox/sandboxsdk
)

PY_SRCS(
    __init__.py

    BuildAndRelease/__init__.py
    BuildArcadiaImageAndDelployToQloud/__init__.py
    RaspBuildRaspDataAndUpdate/__init__.py
    RebuildDocker/__init__.py
    Release/__init__.py

    analytics/__init__.py

    load/GenerateAmmo/__init__.py
    load/GenerateAmmoFromYT/__init__.py
    load/StartFromConfig/__init__.py
    load/StartLoadTesting/__init__.py
    load/__init__.py

    qloud/RestartEnvironment/__init__.py
    qloud/UpdateResources/__init__.py
    qloud/__init__.py
    qloud/api/__init__.py
    qloud/resources_config.py

    suggests/DistributeData/__init__.py
    suggests/DistributeData/msgpack_utils.py
    suggests/__init__.py

    utils/__init__.py
    utils/changelog.py
    utils/retry_task.py
)

END()

RECURSE(
    BuildAndRelease
    BuildArcadiaImageAndDelployToQloud
    CheckFiles
    CheckRaspDataResources
    DumpMysqlDb
    DumpRaspData
    DumpTrainData
    RaspBuildRaspDataAndUpdate
    RebuildDocker
    Release
    TrainsDumpActualDirections
    TrainsDumpTemplates
    TrainsGenerateSitemap
    TrainsGenerateCanonical
    TrainsGenerateCrossLinks
    analytics
    bandit
    bus
    examples
    infra
    load
    marketing
    qloud
    rasp_scripts
    resource_types
    utils
)
