# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.projects import resource_types


class GetFusionCanonicalShard(sdk2.Task):
    """
    Provides DB and configs for Fusion CI tests. Canonical data may be set manually (obtaining from production is not implemented yet)
    """

    class Requirements(sdk2.Task.Requirements):
        disk_space = 50000

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 7200
        with sdk2.parameters.Group("User overrides") as overrides:
            usr_db = sdk2.parameters.Resource('RTYServer index', resource_type=resource_types.RTYSERVER_SEARCH_DATABASE, required=True)
            usr_oxygen_config = sdk2.parameters.Resource('OxygenOptions config', resource_type=resource_types.FUSION_OXYGEN_CONFIG, required=True)
            usr_base_config = sdk2.parameters.Resource('Basesearch config', resource_type=resource_types.SEARCH_CONFIG, required=True)
            usr_rty_config = sdk2.parameters.Resource('RTYServer config', resource_type=resource_types.FUSION_SEARCH_CONFIG, required=True)
            usr_distributors_config = sdk2.parameters.String('RTYServer distributors.conf', required=True)

    class Context(sdk2.Task.Context):
        db = None
        oxygen_config = None
        base_config = None
        rty_config = None
        usr_distributors_config = None

    def on_execute(self):
        # This is a mock. Right now we do nothing other than copying input parameters to output parameters
        # TODO: implement obtaining from production
        self.Context.db = self.Parameters.usr_db.id
        self.Context.oxygen_config = self.Parameters.usr_oxygen_config.id
        self.Context.base_config = self.Parameters.usr_base_config.id
        self.Context.rty_config = self.Parameters.usr_rty_config.id
