# -*- coding: utf-8 -*-

from sandbox.projects.common import error_handlers as eh
from sandbox.projects.release_machine.components.components_info import (
    Branched,
    ComponentInfoGeneral,
    ReferenceComponent,
    ReferenceComponentMetricsed,
    Tagged,
    base,
    mixin,
)
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.configs.ab_experiments import AbExperimentsCfg
from sandbox.projects.release_machine.components.configs.ab_exp import AbExpCfg
from sandbox.projects.release_machine.components.configs.ab_flags import AbFlagsCfg
from sandbox.projects.release_machine.components.configs.ab_flags_testids import AbFlagsTestidsCfg
from sandbox.projects.release_machine.components.configs.all import ALL_CONFIGS
from sandbox.projects.release_machine.components.configs.autoru360_poi import AutoRu360Poi
from sandbox.projects.release_machine.components.configs.cbirdaemon_data import CbirdaemonDataCfg
from sandbox.projects.release_machine.components.configs.cupid import CupidCfg
from sandbox.projects.release_machine.components.configs.cv_universal_py_daemon import CVUniversalPyDaemon
from sandbox.projects.release_machine.components.configs.morty import MortyCfg
from sandbox.projects.release_machine.components.configs.prod_formulas_flags_test import ProdFormulasFlagsTestCfg
from sandbox.projects.release_machine.components.configs.request_sampler import RequestSamplerCfg
from sandbox.projects.release_machine.components.configs.sawmill import SawmillCfg
from sandbox.projects.release_machine.components.configs.sprav_feedback import SpravFeedbackCfg
from sandbox.projects.release_machine.components.configs.stoker import StokerCfg
from sandbox.projects.release_machine.components.configs.yabs_linear_models import YabsLinearModelsCfg
from sandbox.projects.release_machine.components.configs.zephyr import ZephyrCfg
from sandbox.projects.release_machine.components.configs.metrics_templates import MetricsTemplatesCfg
from sandbox.projects.release_machine.components.custom import images_base
from sandbox.projects.release_machine.components.custom import images_robot
from sandbox.projects.release_machine.components.custom import modadvert
from sandbox.projects.release_machine.components.custom.abt import ABTInfo
from sandbox.projects.release_machine.components.custom.afisha import AfishaInfo
from sandbox.projects.release_machine.components.custom.apphost import AppHostInfo
from sandbox.projects.release_machine.components.custom.autosupbs import AutoSupBsComponentInfo
from sandbox.projects.release_machine.components.custom.balance import BalanceInfo
from sandbox.projects.release_machine.components.custom.balancer import BalancerInfo
from sandbox.projects.release_machine.components.custom.balancer_config import BalancerConfigInfo
from sandbox.projects.release_machine.components.custom.base_web import BaseInfo
from sandbox.projects.release_machine.components.custom.bass import BassInfo
from sandbox.projects.release_machine.components.custom.begemot import BegemotInfo
from sandbox.projects.release_machine.components.custom.begemot_megamind import BegemotMegamindInfo
from sandbox.projects.release_machine.components.custom.begemot_request_init import BegemotRequestInitInfo
from sandbox.projects.release_machine.components.custom.bigb import BigbComponentInfo
from sandbox.projects.release_machine.components.custom.bulbasaur import BulbasaurInfo
from sandbox.projects.release_machine.components.custom.collections_backend import CollectionsBackendInfo
from sandbox.projects.release_machine.components.custom.exp_formulas import ExpFormulasInfo
from sandbox.projects.release_machine.components.custom.gemini import GeminiInfo
from sandbox.projects.release_machine.components.custom.geo import GeoCommonInfo
from sandbox.projects.release_machine.components.custom.jupiter import JupiterInfo
from sandbox.projects.release_machine.components.custom.kwyt import KwYTInfo
from sandbox.projects.release_machine.components.custom.quasar import QuasarMultiplatformInfo, QuasarBuildTypesMixin
from sandbox.projects.release_machine.components.custom.rearrange_dynamic import RearrangeDynamicInfo
from sandbox.projects.release_machine.components.custom.release_machine import ReleaseMachineInfo
from sandbox.projects.release_machine.components.custom.release_machine_test import ReleaseMachineTestInfo
from sandbox.projects.release_machine.components.custom.rtcc import RtccInfo
from sandbox.projects.release_machine.components.custom.rthub import RTHubInfo
from sandbox.projects.release_machine.components.custom.rtmr import RtmrInfo
from sandbox.projects.release_machine.components.custom.savedcopy import SavedCopyInfo
from sandbox.projects.release_machine.components.custom.smart_devices import SmartDevicesInfo
from sandbox.projects.release_machine.components.custom.src_setup import SrcSetupInfo
from sandbox.projects.release_machine.components.custom.tunneller import TunnellerInfo
from sandbox.projects.release_machine.components.custom.turbo_pages import TurboPagesInfo
from sandbox.projects.release_machine.components.custom.uac_backend import UacBackendInfo
from sandbox.projects.release_machine.components.custom.uniproxy import UniproxyInfo
from sandbox.projects.release_machine.components.custom.uniproxy_experiments import UniproxyExperimentsInfo
from sandbox.projects.release_machine.components.custom.upper_web import UpperInfo
from sandbox.projects.release_machine.components.custom.user_sessions_base import UserSessionsBaseInfo
from sandbox.projects.release_machine.components.custom.userfeat import UserfeatInfo
from sandbox.projects.release_machine.components.custom.vins import VinsInfo
from sandbox.projects.release_machine.components.custom.hollywood import HollywoodInfo
from sandbox.projects.release_machine.components.custom.weather import WeatherInfo
from sandbox.projects.release_machine.components.custom.yabs.server.yabs_server import YabsServerInfo
from sandbox.projects.release_machine.components.custom.yandexmicro_factory import YandexMicroFactoryInfo
from sandbox.projects.release_machine.components.custom.yandexmidi_factory import YandexMidiFactoryInfo
from sandbox.projects.release_machine.components.custom.yandexmini_2_factory import YandexMini2FactoryInfo
from sandbox.projects.release_machine.components.custom.yandexmodule_2_factory import YandexModule2FactoryInfo
from sandbox.projects.Afisha.rm import COMPONENT_GROUP as AFISHA_COMPONENT_GROUP
from sandbox.projects.plus.rm import COMPONENT_GROUP as PLUS_COMPONENT_GROUP
from sandbox.projects.media_crm.rm import COMPONENT_GROUP as MEDIACRM_COMPONENT_GROUP


class ComponentDict(object):

    def __init__(self):
        self._components = {}
        self._registered = {}
        self._registered_groups = {}

    def _factory(self, component_name, bases, cfg):
        class_name = component_name + "_info"
        return base.ComponentInfoMeta(
            class_name,
            bases,
            {
                '__component_name': component_name,
                '_cfg_cls': cfg,
            }
        )

    def register(self, component_names, bases):
        for component_name in component_names:
            self._registered[component_name] = tuple(bases)

    def register_group(self, group_name, bases):
        self._registered_groups[group_name] = tuple(bases)

    def raise_forbidden(self, name):
        raise TypeError("`{}` is not allowed in {}".format(name, self.__class__.__name__))

    @staticmethod
    def get_bases_default(cfg_cls):

        if isinstance(cfg_cls, configs.ReferenceTaggedConfig):
            return Tagged, mixin.Changelogged

        if cfg_cls.Notify.use_startrek is False:
            return Branched, mixin.Changelogged

        return (ReferenceComponent,)

    def __iter__(self):
        self.raise_forbidden('__iter__')

    def __getitem__(self, component_name):
        if component_name not in self._components:
            cfg = ALL_CONFIGS[component_name]
            if cfg.component_group:
                bases = self._registered_groups[cfg.component_group]
            else:
                bases = self._registered.get(component_name, self.get_bases_default(cfg))
            self._components[component_name] = self._factory(
                component_name,
                bases,
                cfg,
            )
        return self._components[component_name]


COMPONENTS = ComponentDict()


COMPONENTS.register(('abt', ), (ABTInfo,))
COMPONENTS.register(('app_host', ), (AppHostInfo,))
COMPONENTS.register(('app_host_ci', ), (AppHostInfo,))
COMPONENTS.register(('balance', ), (BalanceInfo,))
COMPONENTS.register(('balancer', ), (BalancerInfo,))
COMPONENTS.register(('balancer_config', ), (BalancerConfigInfo,))
COMPONENTS.register(('base', ), (BaseInfo,))
COMPONENTS.register(('bass', ), (BassInfo,))
COMPONENTS.register(('begemot', ), (BegemotInfo,))
COMPONENTS.register(('begemot_megamind', ), (BegemotMegamindInfo,))
COMPONENTS.register(('begemot_request_init', ), (BegemotRequestInitInfo,))
COMPONENTS.register(('berthub', ), (KwYTInfo,))
COMPONENTS.register(('bigb_balancer', ), (BigbComponentInfo,))
COMPONENTS.register(('bigb_oracle', ), (BigbComponentInfo,))
COMPONENTS.register(('bigb_eagle', ), (BigbComponentInfo,))
COMPONENTS.register(('bigb_jaylog', ), (BigbComponentInfo,))
COMPONENTS.register(('bigb_raven', ), (BigbComponentInfo,))
COMPONENTS.register(('bigb_resharder', ), (BigbComponentInfo,))
COMPONENTS.register(('brands', ), (modadvert.BrandsInfo,))
COMPONENTS.register(('autosupbs', ), (AutoSupBsComponentInfo,))
COMPONENTS.register(('bulbasaur', ), (BulbasaurInfo,))
COMPONENTS.register(('caesar_resharder', ), (BigbComponentInfo,))
COMPONENTS.register(('caesar_worker', ), (BigbComponentInfo,))
COMPONENTS.register(('collections_backend', ), (CollectionsBackendInfo,))
COMPONENTS.register(('exp_formulas_base', 'exp_formulas_mmeta'), (ExpFormulasInfo,))
COMPONENTS.register(('gemini', ), (GeminiInfo,))
COMPONENTS.register(('hollywood', ), (HollywoodInfo,))
COMPONENTS.register(('images_base', ), (images_base.ImagesBaseInfo,))
COMPONENTS.register(('images_robot', ), (images_robot.ImagesRobotInfo,))
COMPONENTS.register(('jupiter', ), (JupiterInfo,))
COMPONENTS.register(('kwyt', ), (KwYTInfo,))
COMPONENTS.register(('lyncher', ), (modadvert.LyncherInfo,))
COMPONENTS.register(('quasar_yandexstation_2', ), (QuasarBuildTypesMixin, QuasarMultiplatformInfo))
COMPONENTS.register(('rearrange_dynamic', ), (RearrangeDynamicInfo,))
COMPONENTS.register(('release_machine', ), (ReleaseMachineInfo,))
COMPONENTS.register(('release_machine_test', ), (ReleaseMachineTestInfo,))
COMPONENTS.register(('release_machine_test_tagged', ), (Tagged, mixin.Changelogged,))
COMPONENTS.register(('rtcc', ), (RtccInfo,))
COMPONENTS.register(('rthub', ), (RTHubInfo,))
COMPONENTS.register(('rtmr', ), (RtmrInfo,))
COMPONENTS.register(('savedcopy', ), (SavedCopyInfo,))
COMPONENTS.register(('smart_devices', ), (SmartDevicesInfo,))
COMPONENTS.register(('src_setup', ), (SrcSetupInfo,))
COMPONENTS.register(('supermoderation', ), (modadvert.SupermoderationInfo,))
COMPONENTS.register(('tunneller', ), (TunnellerInfo,))
COMPONENTS.register(('turbo_pages', ), (TurboPagesInfo,))
COMPONENTS.register(('uac_backend',), (UacBackendInfo,))
COMPONENTS.register(('uniproxy',), (UniproxyInfo,))
COMPONENTS.register(('uniproxy_experiments', ), (UniproxyExperimentsInfo,))
COMPONENTS.register(('upper', ), (UpperInfo,))
COMPONENTS.register(('user_sessions', ), (UserSessionsBaseInfo,))
COMPONENTS.register(('userfeat', ), (UserfeatInfo,))
COMPONENTS.register(('vins', ), (VinsInfo,))
COMPONENTS.register(('weather', ), (WeatherInfo,))
COMPONENTS.register(('ya_stroka', ), (Tagged, mixin.Changelogged, mixin.Startreked))
COMPONENTS.register(('yabs_server', ), (YabsServerInfo,))
COMPONENTS.register(('yandexmicro_factory', ), (YandexMicroFactoryInfo,))
COMPONENTS.register(('yandexmidi_factory', ), (YandexMidiFactoryInfo,))
COMPONENTS.register(('yandexmini_2_factory', ), (YandexMini2FactoryInfo,))
COMPONENTS.register(('yandexmodule_2_factory', ), (YandexModule2FactoryInfo,))
COMPONENTS.register(
    (
        AbExperimentsCfg.name,
        AbFlagsCfg.name,
        AbFlagsTestidsCfg.name,
        ProdFormulasFlagsTestCfg.name
    ),
    (Tagged, mixin.Changelogged, mixin.Metricsed)
)
COMPONENTS.register((CupidCfg.name,), (modadvert.CupidInfo,))
COMPONENTS.register((StokerCfg.name, MortyCfg.name), (Tagged,))
COMPONENTS.register((MetricsTemplatesCfg.name,), (Branched, mixin.Changelogged, mixin.Metricsed))
COMPONENTS.register((AbExpCfg.name,), (Branched, mixin.Changelogged, mixin.Metricsed))


COMPONENTS.register(
    (
        CVUniversalPyDaemon.name,
        SpravFeedbackCfg.name,
        RequestSamplerCfg.name,
        ZephyrCfg.name,
        SawmillCfg.name,
    ),
    (Branched, mixin.Changelogged)
)
COMPONENTS.register(
    (
        AutoRu360Poi.name,
        CbirdaemonDataCfg.name,
        YabsLinearModelsCfg.name,
    ),
    (Tagged, mixin.Changelogged)
)

COMPONENTS.register_group(AFISHA_COMPONENT_GROUP, (AfishaInfo,))
COMPONENTS.register_group(PLUS_COMPONENT_GROUP, (AfishaInfo,))
COMPONENTS.register_group(MEDIACRM_COMPONENT_GROUP, (AfishaInfo,))
COMPONENTS.register_group('media-billing', (AfishaInfo,))
COMPONENTS.register_group('afishadevelopment', (AfishaInfo,))
COMPONENTS.register_group('component_info_general', (ComponentInfoGeneral, ))
COMPONENTS.register_group('geo_common', (GeoCommonInfo, ))
COMPONENTS.register_group('reference_component_metricsed', (ReferenceComponentMetricsed, ))
COMPONENTS.register_group('apphost_verticals', (ReferenceComponent, ))
COMPONENTS.register_group('ya_tool_based', (Tagged, mixin.Changelogged))
COMPONENTS.register_group('ya_tool_based_ci', (Branched, mixin.Changelogged))


def get_component_names():
    return list(ALL_CONFIGS.keys())


def get_component(component_name):
    """
    Component object factory
    """
    return COMPONENTS[component_name]()


def check_component_name(component_name):
    eh.ensure(
        component_name in get_component_names(),
        "Non-existing release machine component name: `{}`".format(component_name),
    )
