import re

from sandbox.projects.release_machine.components.config_core.bases import base
from sandbox.projects.release_machine.core import const as rm_const


class ReferenceTrunkConfig(base.ReferenceConfig):
    """ For very small components, with releases directly from trunk"""
    release_cycle_type = rm_const.ReleaseCycleType.TRUNK

    class Notify(base.ReferenceConfig.Notify):
        use_startrek = False

    class SvnCfg(base.RmSvnCfg):
        def _get_major_release_num(self, url):
            """
            Get major release number from arcadia url for trunk components
            :param url: str, where we search major_num. Major_num for trunk components is svn revision.
            :return major_num if we found it, else 0
            """
            found = re.search("@([0-9]{4,})", url)
            if found:
                return int(found.group(1))
            return 0

    class Testenv(base.ReferenceConfig.Testenv):
        @property
        def db_template(self):
            return self.trunk_db

    @property
    def is_trunk(self):
        """Return True if config is trunk"""
        return True
