import sys

from google.protobuf import text_format

from sandbox.projects.release_machine.components.configs import all as all_cfg
from sandbox.projects.release_machine.components.config_core import config_serializer


def print_serialized_config(component_name, token):
    cfg = all_cfg.get_config(component_name)
    cfg_serialized = config_serializer.config2proto(cfg, token=token)
    print(text_format.MessageToString(cfg_serialized))


def main():

    if len(sys.argv) < 2:
        print("Usage: config_serializer <component_name> [<token>]")

    component_name = sys.argv[1]
    token = sys.argv[2] if len(sys.argv) >= 3 else None

    print_serialized_config(component_name, token)


if __name__ == "__main__":
    main()
