from sandbox.projects.release_machine.components.config_core.jg.cube import CubeInput
from sandbox.projects.release_machine.components.config_core.jg.cube.lib.alice.evo import BaseEvoContext


class BegemotMegamindEvoContext(BaseEvoContext):
    def __init__(self, generate_beta_cube, component_name):
        super(self.__class__, self).__init__(
            name="begemot_megamind_evo_context",
            title="EvoContext",
            task="projects/alice/begemot/begemot_megamind_evo_context",
            input=CubeInput(
                evo_in_component_name=component_name,
            ),
            needs=[generate_beta_cube],
            component_name=component_name,
        )

    @property
    def input_defaults(self):
        return {
            "backend_name": "ALICE__BEGEMOT_WORKER_MEGAMIND",
        }

    @property
    def megamind_url(self):
        return self.output_params.evo_out_begemot_megamind_url
