from sandbox.projects.release_machine.components.config_core.jg.cube import Cube


class BaseEvoContext(Cube):
    def __init__(self, name, title, task, input, needs, component_name):
        super(BaseEvoContext, self).__init__(
            name=name,
            title=title,
            task=task,
            input=input,
            needs=needs,
        )
        self._component_name = component_name

    @property
    def component_name(self):
        return self._component_name

    @property
    def branch_number(self):
        return "${context.version_info.major}"

    @property
    def tag_number(self):
        return "${not_null(context.version_info.minor, `0`)}"

    @property
    def beta_name(self):
        return self.output_params.evo_out_beta_name

    @property
    def last_released_beta_name(self):
        return self.output_params.last_released_beta_name

    @property
    def release_ticket(self):
        return self.output_params.evo_out_release_ticket

    @property
    def megamind_url(self):
        raise NotImplementedError()
