from sandbox.projects.release_machine.components.config_core.jg.cube import (
    Cube,
    CubeInput,
)


class AliceEvoUe2e(Cube):

    NAME = "alice_evo_ue2e"

    def __init__(self, input, evo_context):
        if evo_context:
            input = self._enrich_input_from_evo_ctx(input, evo_context)
        super(self.__class__, self).__init__(
            name=self.NAME,
            title="Ue2e",
            task="projects/alice/alice_evo_ue2e",
            input=input,
        )

    @staticmethod
    def _enrich_input_from_evo_ctx(input, evo_context):
        input_from_ctx = CubeInput(
            component_name=evo_context.component_name,
            branch_num=evo_context.branch_number,
            tag_num=evo_context.tag_number,
            release_ticket=evo_context.release_ticket,
        )
        input_from_ctx.merge(input)
        return input_from_ctx
