from sandbox.projects.release_machine.components.config_core.jg.cube import base as cube_base


class ReleaseMachineConfigCrawler(cube_base.Cube):
    TASK = "projects/release_machine/release_machine_config_crawler"

    def __init__(
        self,
        name,
        component_name_filter="",
        rm_host="",
        light_mode=True,
        update_declarative_notifications=True,
        **kwargs
    ):

        self._component_name_filter = component_name_filter
        self._rm_host = rm_host
        self._light_mode = light_mode
        self._update_declarative_notifications = update_declarative_notifications

        super(ReleaseMachineConfigCrawler, self).__init__(name=name, task=self.TASK, **kwargs)

    @property
    def input_override(self):
        return {
            "component_name_filter": self._component_name_filter,
            "rm_host": self._rm_host,
            "light_mode": self._light_mode,
            "update_declarative_notifications": self._update_declarative_notifications,
        }
