from sandbox.projects.release_machine.components.config_core.jg.cube import base as cube_base


class RunAlembicMigrations(cube_base.Cube):

    TASK = "projects/release_machine/run_alembic_migrations"

    def __init__(
        self,
        component_name,
        db_url_yav_secret_uuid,
        db_url_yav_secret_name,
        project_root,
        alembic_command="upgrade head",
        **kwargs
    ):
        self._component_name = component_name
        self._db_url_yav_secret_uuid = db_url_yav_secret_uuid
        self._db_url_yav_secret_name = db_url_yav_secret_name
        self._project_root = project_root
        self._alembic_command = alembic_command

        kwargs["task"] = self.TASK

        super(RunAlembicMigrations, self).__init__(**kwargs)

    @property
    def input_override(self):
        return {
            "component_name": self._component_name,
            "db_url_yav_secret_uuid": self._db_url_yav_secret_uuid,
            "db_url_yav_secret_name": self._db_url_yav_secret_name,
            "project_root": self._project_root,
            "alembic_command": self._alembic_command,
        }

    def clone(self, **kwargs):
        new_cube_kwargs = dict(
            component_name=self._component_name,
        )

        new_cube_kwargs.update(kwargs)
        return super(RunAlembicMigrations, self).clone(**new_cube_kwargs)
