from sandbox.projects.release_machine.components.config_core.jg.cube import base as cube_base


class Dummy(cube_base.Cube):
    TYPE = "dummy"
    TASK = "dummy"

    def __init__(self, name=None, **kwargs):
        kwargs["task"] = self.TASK
        kwargs["name"] = name or self.TYPE
        super(Dummy, self).__init__(**kwargs)


class RMMainGraphEntry(Dummy):
    """
    For Release Machine internal use only! Do NOT use it under any circumstances

    A dummy cube with a predefined name which serves as an entry point (right after the NewTag cube) for
    Release Machine main release graph. This cube existence is warranted by the requirements of CI release
    stages and the fact that we want our NewTag cube to be on a separate stage (see RMDEV-2582)
    """

    NAME = "main_graph_entry"

    def __init__(self, **kwargs):
        kwargs["name"] = self.NAME
        super(RMMainGraphEntry, self).__init__(**kwargs)


class ReleaseStageEntry(Dummy):
    """
    For Release Machine internal use only! Do NOT use it under any circumstances

    A dummy cube with a predefined name which serves as an entry point (right after the NewTag cube) for
    for the release part of Release Machine graph. This cube existence is warranted by the requirements of CI release
    stages (see RMDEV-2582)
    """

    NAME = "release_stage_entry"

    def __init__(self, **kwargs):
        kwargs["name"] = self.NAME
        super(ReleaseStageEntry, self).__init__(**kwargs)


class ReleaseStableStageEntry(Dummy):
    """
    For Release Machine internal use only! Do NOT use it under any circumstances

    A dummy cube with a predefined name which serves as an entry point (right after the NewTag cube) for
    for the release part of Release Machine graph. This cube existence is warranted by the requirements of CI release
    stages (see RMDEV-2582)
    """

    NAME = "release_stable_stage_entry"

    def __init__(self, **kwargs):
        kwargs["name"] = self.NAME
        super(ReleaseStableStageEntry, self).__init__(**kwargs)


class ReleasePrestableStageEntry(Dummy):
    """
    For Release Machine internal use only! Do NOT use it under any circumstances

    A dummy cube with a predefined name which serves as an entry point (right after the NewTag cube) for
    for the release part of Release Machine graph. This cube existence is warranted by the requirements of CI release
    stages (see RMDEV-2582)
    """

    NAME = "release_prestable_stage_entry"

    def __init__(self, **kwargs):
        kwargs["name"] = self.NAME
        super(ReleasePrestableStageEntry, self).__init__(**kwargs)


class TestStageEntry(Dummy):
    """
    For Release Machine internal use only! Do NOT use it under any circumstances

    A dummy cube with a predefined name which serves as an entry point (right after the NewTag cube) for
    for the test part of Release Machine graph. This cube existence is warranted by the requirements of CI release
    stages (see RMDEV-2582)
    """

    NAME = "test_stage_entry"

    def __init__(self, **kwargs):
        kwargs["name"] = self.NAME
        super(TestStageEntry, self).__init__(**kwargs)


class SleepCube(Dummy):
    TYPE = "sleep"
    TASK = "common/misc/sleep"

    def __init__(self, sleep_time_str, **kwargs):
        self._sleep_time_str = sleep_time_str
        super(SleepCube, self).__init__(**kwargs)

    @property
    def input_override(self):
        return {
            "config": {
                "sleep_time": self._sleep_time_str,
            },
        }
