from sandbox.projects.release_machine.components.config_core.jg.cube.lib import internal as internal_cubes


class RunIceFlame(internal_cubes.ReleaseMachineInternalSandboxTaskCube):

    TASK = "projects/iceflame/run_ice_flame"
    TYPE = "test"
    NAME = "run_ice_flame"

    RELEASE_MACHINE_DEFAULT_YAV_SECRET = "sec-01ejz9hcr8tq4mmwga719ecgt0"
    SECRET_DEFAULT_SSH_KEY_NAME = "ssh_key"
    SECRET_DEFAULT_SANDBOX_TOKEN_NAME = "common_release_token"
    SECRET_DEFAULT_NANNY_TOKEN_NAME = "common_release_token"

    def __init__(self, component_name, config_file="", **kwargs):
        self._config_file = config_file
        super(RunIceFlame, self).__init__(component_name=component_name, **kwargs)

    @property
    def input_defaults(self):
        return {
            "iceflame_config_source": "file" if self._config_file else "input_json",
            "iceflame_config_file": self._config_file,
            "release_machine_mode": True,
            "iceflame_command_run_options_json": {
                "remote_collector_options": {
                    "analyze_inplace": True,
                    "build_flamegraph": True,
                },
            },
            "ssh_login": "robot-srch-releaser",
            "ssh_key_secret": "{}#{}".format(
                self.RELEASE_MACHINE_DEFAULT_YAV_SECRET,
                self.SECRET_DEFAULT_SSH_KEY_NAME,
            ),
            "sandbox_token_secret": "{}#{}".format(
                self.RELEASE_MACHINE_DEFAULT_YAV_SECRET,
                self.SECRET_DEFAULT_SANDBOX_TOKEN_NAME,
            ),
            "nanny_token_secret": "{}#{}".format(
                self.RELEASE_MACHINE_DEFAULT_YAV_SECRET,
                self.SECRET_DEFAULT_NANNY_TOKEN_NAME,
            ),
        }


class RunIceFlameForReleaseItem(RunIceFlame):

    def __init__(
        self,
        component_name,
        release_item_name,
        service_name,
        config_file="",
        fail_if_service_version_cannot_be_determined=False,
        check_production_version=True,
        **kwargs
    ):

        self._release_item_name = release_item_name
        self._service_name = service_name
        self._fail_if_service_version_cannot_be_determined = fail_if_service_version_cannot_be_determined
        self._check_production_version = check_production_version

        super(RunIceFlameForReleaseItem, self).__init__(component_name, config_file, **kwargs)

    @property
    def input_override(self):
        return {
            "release_item_name": self._release_item_name,
            "service_name": self._service_name,
            "fail_if_service_version_cannot_be_determined": self._fail_if_service_version_cannot_be_determined,
            "check_production_version": self._check_production_version,
        }
