import os
from sandbox.projects.release_machine.components.config_core.jg.cube.base import Cube
from sandbox.projects.release_machine.components.config_core.jg.cube.lib.internal import TYPE_TEST


class InfraBaseTestCube(Cube):
    TYPE = TYPE_TEST


class InfraDiffTestCube(InfraBaseTestCube):
    def __init__(self, ci_task_filename, **kwargs):
        """
        :type ci_task_filename: str
        :param ci_task_filename:
            Task's filename from ci/registry project
        """

        ci_task_dir = "projects/infra"

        super(InfraDiffTestCube, self).__init__(task=os.path.join(ci_task_dir, ci_task_filename), **kwargs)
