from sandbox.projects.release_machine.components.config_core.jg.cube import base as cube_base
from sandbox.projects.release_machine.core import const as rm_const


class ReleaseMachineInternalCube(cube_base.Cube):

    TASK = None
    NAME = None

    def __init__(self, component_name, **kwargs):
        self._component_name = component_name

        kwargs = self.prepare_kwargs(kwargs)

        super(ReleaseMachineInternalCube, self).__init__(**kwargs)

    def prepare_kwargs(self, kwargs_dict):
        kwargs_dict["task"] = self.TASK

        if "name" not in kwargs_dict:
            kwargs_dict["name"] = self.NAME

        return kwargs_dict

    @property
    def component_name(self):
        return self._component_name


class ReleaseMachineInternalTaskletCube(ReleaseMachineInternalCube):

    def prepare_kwargs(self, kwargs_dict):

        cube_input = kwargs_dict.get("input", cube_base.CubeInput())

        config = cube_input.get("config", {})
        config.update(self.input_config)
        cube_input.update(config=config)

        kwargs_dict["input"] = cube_input

        kwargs_dict = super(ReleaseMachineInternalTaskletCube, self).prepare_kwargs(kwargs_dict)

        return kwargs_dict

    @property
    def input_config(self):
        return {
            "component_name": self.component_name,
        }


class ReleaseMachineInternalSandboxTaskCube(ReleaseMachineInternalCube):

    def prepare_kwargs(self, kwargs_dict):
        kwargs_dict = super(ReleaseMachineInternalSandboxTaskCube, self).prepare_kwargs(kwargs_dict)
        cube_input = kwargs_dict.get("input", cube_base.CubeInput())
        cube_input.update(component_name=self.component_name)
        kwargs_dict["input"] = cube_input
        return kwargs_dict


TYPE_CHANGELOG = "changelog"
TYPE_STARTREK = "startrek"
TYPE_MERGE = "merge"
TYPE_RM_INTERNAL = "rm_internal"
TYPE_TEST = "test"


class NewTagCube(ReleaseMachineInternalTaskletCube):
    TASK = "projects/release_machine/create_arc_tag"
    TYPE = "new_tag"
    NAME = "new_tag"


class CreateChangelog(ReleaseMachineInternalSandboxTaskCube):
    TASK = "projects/release_machine/release_machine_changelog"
    TYPE = TYPE_CHANGELOG
    NAME = "create_changelog"


class FormatChangelog(ReleaseMachineInternalTaskletCube):
    TASK = "projects/release_machine/format_rm_changelog"
    TYPE = TYPE_CHANGELOG
    NAME = "format_changelog"


class PostChangelogToStartrek(ReleaseMachineInternalSandboxTaskCube):
    TASK = "projects/release_machine/post_startrek_comment"
    TYPE = TYPE_CHANGELOG
    NAME = "post_changelog_to_startrek"


class CreateStartrekTicket(ReleaseMachineInternalTaskletCube):
    TASK = "projects/release_machine/get_or_create_st_ticket"
    TYPE = TYPE_STARTREK
    NAME = "create_startrek_ticket"


class LinkFeatureTickets(ReleaseMachineInternalTaskletCube):
    TASK = "projects/release_machine/link_feature_tickets_from_changelog"
    TYPE = TYPE_STARTREK
    NAME = "link_feature_tickets"


class CreateWikiPageWithChangelog(ReleaseMachineInternalSandboxTaskCube):
    TASK = "projects/release_machine/create_wiki_page"
    TYPE = TYPE_CHANGELOG
    NAME = "create_wiki_page_with_changelog"


class CreateSvnBranch(ReleaseMachineInternalSandboxTaskCube):
    TASK = "projects/release_machine/create_svn_branch"
    TYPE = "create_svn_branch"
    NAME = "create_svn_branch"

    def prepare_kwargs(self, kwargs_dict):
        kwargs_dict = super(ReleaseMachineInternalSandboxTaskCube, self).prepare_kwargs(kwargs_dict)
        cube_input = kwargs_dict.get("input", cube_base.CubeInput())
        cube_input.update(
            component_name=self.component_name,
            tag_or_branch_mode=rm_const.BranchingMode.TRUNK_TO_BRANCH,
            svn_branch_only=True,
        )
        kwargs_dict["input"] = cube_input
        return kwargs_dict


class MergeToStable(ReleaseMachineInternalSandboxTaskCube):
    TASK = "projects/release_machine/merge_to_stable"
    TYPE = TYPE_MERGE
    NAME = "merge_to_stable"


class PrepareCiEnvironment(ReleaseMachineInternalSandboxTaskCube):
    TASK = "projects/release_machine/prepare_ci_environment"
    TYPE = TYPE_RM_INTERNAL
    NAME = "prepare_ci_environment"
