from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import internal
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import yappy
from sandbox.projects.release_machine.components.config_core.jg.cube import base as cube_base


class LaunchMetrics(internal.ReleaseMachineInternalSandboxTaskCube):

    TASK = "projects/release_machine/launch_metrics"
    TYPE = internal.TYPE_TEST

    def __init__(self, component_name, search_subtype, **kwargs):
        self._search_subtype = search_subtype
        super(LaunchMetrics, self).__init__(component_name=component_name, **kwargs)

    @property
    def input_defaults(self):
        return {
            "metrics_mode_type": "release_machine",
            "release_number": rm_const.CIJMESPathCommon.MAJOR_RELEASE_NUM,
            "minor_release_number": rm_const.CIJMESPathCommon.MINOR_RELEASE_NUM,
        }

    @property
    def input_override(self):
        return {
            "search_subtype": self._search_subtype,
        }

    @classmethod
    def by_generate_beta_cube(cls, generate_beta_cube, **kwargs):

        if not isinstance(generate_beta_cube, yappy.GenerateYappyBeta):
            raise TypeError("Expected {} instance, got {}".format(yappy.GenerateYappyBeta, type(generate_beta_cube)))

        if "input" not in kwargs:
            kwargs["input"] = cube_base.CubeInput()

        kwargs["input"].update(checked_beta=generate_beta_cube.output_params.new_beta_url)

        return cls(
            component_name=generate_beta_cube.component_name,
            search_subtype=generate_beta_cube.beta_conf_type,
            **kwargs
        )


class SearchLaunchMetrics(LaunchMetrics):
    LAUNCH_TEMPLATE_QUOTA = ""

    def __init__(self, component_name, search_subtype, **kwargs):
        self._scraper_over_yt_pool = kwargs.pop("scraper_over_yt_pool", "")
        super(SearchLaunchMetrics, self).__init__(component_name, search_subtype, **kwargs)

    @property
    def input_defaults(self):
        parent_defaults = super(SearchLaunchMetrics, self).input_defaults
        parent_defaults.update({
            "sample_beta": "hamster",
            "run_findurl": False,
            "scraper_over_yt_pool": self._scraper_over_yt_pool,
            "autoclicker_metric_name": "diff-2-serps-empty-or-failed-5",
            "autoclicker_retry_count": 4,
            "enable_autoclicker": True,
            "custom_template_name": "common.json",
            "minor_release_number": rm_const.CIJMESPathCommon.MINOR_RELEASE_NUM,
            "wait_consistency": True,
            "beta_conf_type": self._search_subtype,
            "launch_template_quota": self.LAUNCH_TEMPLATE_QUOTA,
        })
        return parent_defaults


class SearchLaunchMetricsWeb(SearchLaunchMetrics):
    LAUNCH_TEMPLATE_QUOTA = "web-ranking-runtime"


class SearchLaunchMetricsImages(SearchLaunchMetrics):
    LAUNCH_TEMPLATE_QUOTA = "images-ranking"


class SearchLaunchMetricsVideo(SearchLaunchMetrics):
    LAUNCH_TEMPLATE_QUOTA = "video-quality"
