from sandbox.projects.release_machine.components.config_core.jg.cube import base as cube_base


class CommitNannyService(cube_base.Cube):

    TYPE = "release"
    TASK = "common/nanny/update_service"

    def __init__(self, service_name, releasable_items, release_title=None, release_description=None, **kwargs):

        self._service_name = service_name
        self._releasable_items = releasable_items
        self._release_title = release_title
        self._release_description = release_description

        kwargs["task"] = self.TASK

        super(CommitNannyService, self).__init__(**kwargs)

    def _construct_name(self):
        return "{cube_type}__nanny_commit_{service_name}".format(
            cube_type=self.TYPE,
            service_name=self._service_name
        ).lower()

    @property
    def input_defaults(self):
        patches = []
        for ri in self._releasable_items:
            if not hasattr(ri.data, "resource_type") or not hasattr(ri.data, "dst_path"):
                continue

            patches.append({
                "sandbox": {
                    "resource_type": ri.data.resource_type,
                    "resource": {
                        "local_path": ri.data.dst_path
                    }
                }
            })

        config = {
            "service_id": self._service_name,
            "patches": patches,
            "target_status": "COMMITTED"
        }

        if self._release_title:
            config["release_title"] = self._release_title
        if self._release_description:
            config["release_description"] = self._release_description

        return {"config": config}


class ActivateNannyService(cube_base.Cube):

    TYPE = "release"
    TASK = "common/nanny/set_snapshot_state"

    def __init__(self, service_name, **kwargs):

        self._service_name = service_name

        kwargs["task"] = self.TASK

        super(ActivateNannyService, self).__init__(**kwargs)

    def _construct_name(self):
        return "{cube_type}__nanny_activate_{service_name}".format(
            cube_type=self.TYPE,
            service_name=self._service_name
        ).lower()

    @property
    def input_defaults(self):
        config = {
            "default_activate_recipe": {
                "recipe": "LOCATIONWISE",
                "manual_confirmation": False
            },
            "target_status": "ACTIVE",
            "snapshot": {
                "service_id": self._service_name
            }
        }

        return {"config": config}
