from os import path
from sandbox.projects.release_machine.components.config_core.jg.cube.base import Cube
from sandbox.projects.common import constants as sandbox_constants
from sandbox.projects.release_machine.components.config_core.jg.cube.lib.internal import TYPE_TEST


class SearchReleasesBaseTestCube(Cube):
    TYPE = TYPE_TEST


class SearchReleasesBetaTestCube(SearchReleasesBaseTestCube):
    def __init__(self, ci_task_filename, **kwargs):
        """
        :type ci_task_filename: str
        :param ci_task_filename:
            Task's filename from ci/registry project
        """

        ci_task_dir = "projects/upper_search/base"

        attrs = {
            "if": "${!contains(keys(context.version_info), 'minor')}",
        }

        if "attributes" in kwargs:
            for key, value in attrs.items():
                if key in kwargs["attributes"]:
                    kwargs["attributes"][key].update(value)
                else:
                    kwargs["attributes"][key] = value
        else:
            kwargs["attributes"] = attrs

        super(SearchReleasesBetaTestCube, self).__init__(task=path.join(ci_task_dir, ci_task_filename), **kwargs)


class SearchReleasesBuildTestCube(SearchReleasesBaseTestCube):
    def __init__(self, task="common/arcadia/ya_make", **kwargs):
        attrs = {
            "requirements": {
                "disk": "1TB",
            },
        }

        if "attributes" in kwargs:
            for key, value in attrs.items():
                if key in kwargs["attributes"]:
                    kwargs["attributes"][key].update(value)
        else:
            kwargs["attributes"] = attrs

        super(SearchReleasesBuildTestCube, self).__init__(task=task, **kwargs)

    @property
    def input_defaults(self):
        return {
            sandbox_constants.YA_TIMEOUT: 5 * 60 * 60,  # 5 hours in seconds
            sandbox_constants.DISABLE_TEST_TIMEOUT: True,
            sandbox_constants.BUILD_SYSTEM_KEY: sandbox_constants.YMAKE_BUILD_SYSTEM,
            sandbox_constants.ALLOW_AAPI_FALLBACK: True,
            sandbox_constants.USE_AAPI_FUSE: True,
            sandbox_constants.USE_ARC_INSTEAD_OF_AAPI: False,
            sandbox_constants.TESTS_REQUESTED: True,
        }
