from sandbox.projects.release_machine.components.config_core.jg.cube.lib.iceflame import RunIceFlameForReleaseItem
from sandbox.projects.release_machine.components.config_core.jg.cube.base import CubeInput


class IceFlamePatched(RunIceFlameForReleaseItem):
    def __init__(self, component_name, release_item_name, service_name, config_file):
        """
        :type component_name: six.string_types
        :param component_name:
            Component's name

        :type release_item_name: six.string_types
        :param release_item_name:
            The name (name attribute) of one of the "release items" listed in the releasable_items section of the component's config -
            the one from which we want to remove the perf; Required for correct version detection

        :type service_name: six.string_types
        :param service_name:
            Service to which we will go; Required for correct version detection
        """
        patch_override = "NANNY_SERVICE_NAME={0}".format(service_name)
        super(IceFlamePatched, self).__init__(
            component_name, release_item_name, service_name, config_file, input=CubeInput(env_vars=patch_override)
        )

    @property
    def input_override(self):
        overrides = super(IceFlamePatched, self).input_override
        overrides["iceflame_command_run_options_json"] = {"apply_config_patch": "change_nanny_name"}
        return overrides
