from sandbox.projects.release_machine.components.config_core.jg.cube.base import Cube
from sandbox.projects.release_machine.core import const as rm_const


class TestReportFunctionalOpt(Cube):
    def __init__(self, entry_cube, component_name, **kwargs):
        """
        :type entry_cube: RMMainGraphEntry
        :param entry_cube:
            Entry cube for build stage

        :type component_name: str
        :param component_name:
            RM component name
        """

        self.component_name = component_name

        super(TestReportFunctionalOpt, self).__init__(
            name="test_report_functional_opt" if "name" not in kwargs else kwargs.pop("name"),
            task="projects/upper_search/base/report_functional",
            needs=[entry_cube],
            **kwargs
        )

    @property
    def input_defaults(self):
        return {
            "project": "WEB",
            "svn_url": "https://a.yandex-team.ru/arc/branches/report_ci/{}/arcadia/web/report?revision={}".format(
                rm_const.CIJMESPathCommon.MAJOR_RELEASE_NUM, "${context.target_revision.number}"
            ),
            "env_addition": "IS_BETA=1 MAX_CLIENTS=4",
            "svn_url_function_test": "https://a.yandex-team.ru/arc/branches/report_ci/{}/arcadia/search/garden/runtime_tests?revision={}".format(
                rm_const.CIJMESPathCommon.MAJOR_RELEASE_NUM, "${context.target_revision.number}"
            ),
            "run_test_param": (
                "--enable_datatests "
                "--force-flaky "
                # if test is permanently broken, re-runs won't help you
                # so 2 runs is sufficient
                # ... okay, 3 (on 2 they become flaky)
                "--max-runs=3 "
                "--min-passes=1 "
                "--no-success-flaky-report "
                "--flaky_hack "
            ),
            "test_iterations_max": 3,
            "test_path_param": [
                "report/functional/web",
                "report/functional/people",
                "report/integration/web",
                "report/integration/xml/test_web_xml.py",
            ],
            "release_number": rm_const.CIJMESPathCommon.MAJOR_RELEASE_NUM,
            "component_name": self.component_name,
        }


class TestReportFunctionalInvertedOpt(TestReportFunctionalOpt):
    def __init__(self, entry_cube, component_name, **kwargs):
        super(TestReportFunctionalInvertedOpt, self).__init__(
            name="test_report_functional_inverted_opt",
            entry_cube=entry_cube,
            component_name=component_name,
            **kwargs
        )

    @property
    def input_override(self):
        return {
            "env_addition": "IS_BETA=1 MAX_CLIENTS=4 REPORT_INVERTED=1",
            "test_path_param": "report/functional/inverted",
        }
