from sandbox.projects.release_machine.components.config_core.jg.cube.base import Cube, CubeInput
from sandbox.projects.release_machine.components.config_core.jg.cube.lib.build import YaMake2
from sandbox.projects.common.constants import constants as common_const
from sandbox.projects.release_machine.components.config_core.jg.cube.lib.build import TYPE_BUILD


class BuildNoapacheUpper(YaMake2):
    def __init__(self, new_tag_cube):
        targets = {
            "NOAPACHE_UPPER": "search/daemons/noapacheupper",
            "EVLOGDUMP_EXECUTABLE": "search/tools/evlogdump",
            "APP_HOST_TOOL_CONVERTER_EXECUTABLE": "apphost/tools/converter",
        }

        super(BuildNoapacheUpper, self).__init__(
            targets=targets.values(),
            artifacts=["{}/{}".format(v, v.split("/")[-1]) for v in targets.values()],
            resource_types=targets.keys(),
            name="build_noapache_upper",
            needs=[new_tag_cube],
            attributes={
                "requirements": {
                    "disk": "80GB",
                },
            },
        )

    @property
    def input_override(self):
        override = super(BuildNoapacheUpper, self).input_override
        override.update({
            common_const.THINLTO: True,
            common_const.DEFINITION_FLAGS_KEY: '-DNN_NO_OPENMP',
        })

        return override


class BuildRearrange(Cube):
    TYPE = TYPE_BUILD

    def __init__(self, new_tag_cube):
        self._new_tag_cube = new_tag_cube

        super(BuildRearrange, self).__init__(
            name="build_rearrange",
            task="projects/upper_search/noapache/build_rearrange",
            needs=[new_tag_cube],
        )

    @property
    def input_defaults(self):
        return {
            "rearrange_svn_url": "{}/arcadia/search/web/rearrs_upper/rearrange".format(
                CubeInput.format_cube_output_value(self._new_tag_cube.output.svn_data.svn_paths.tag),
            ),
            "trivial_naming": True,
            common_const.USE_AAPI_FUSE: True,
            common_const.ALLOW_AAPI_FALLBACK: True,
        }


class BuildRearrangeDynamic(YaMake2):  # NOTE: RD releases apart
    def __init__(self, new_tag_cube):
        targets = "search/web/rearrs_upper/rearrange.dynamic"

        super(BuildRearrangeDynamic, self).__init__(
            targets=targets,
            artifacts=targets,
            resource_types="REARRANGE_DYNAMIC_DATA",
            name="build_rearrange_dynamic",
            needs=[new_tag_cube],
            attributes={
                "requirements": {
                    "disk": "80GB",
                    "cores": 24,
                },
            },
        )


class BuildRtccBundle(Cube):
    TYPE = TYPE_BUILD

    def __init__(self, new_tag_cube):
        super(BuildRtccBundle, self).__init__(
            name="build_rtcc_bundle",
            task="projects/upper_search/noapache/build_upper_config",
            needs=[new_tag_cube],
        )

    @property
    def input_defaults(self):
        return {
            "config_type": "noapache",
            "bundle_type": "production_noapache",
        }


class BuildRearrangeDataFast(Cube):
    TYPE = TYPE_BUILD

    def __init__(self, new_tag_cube, vertical):
        self._new_tag_cube = new_tag_cube
        self._vertical = vertical

        super(BuildRearrangeDataFast, self).__init__(
            name="build_rearrange_data_fast_{}".format(vertical),
            task="projects/upper_search/noapache/build_rearrange_data_fast",
            needs=[new_tag_cube],
        )

    @property
    def input_defaults(self):
        return {
            "arcadia_url": "{}/arcadia".format(
                CubeInput.format_cube_output_value(self._new_tag_cube.output.svn_data.svn_paths.tag),
            ),
            "vertical": self._vertical,
            "arc_token_owner": "NOAPACHEUPPER-ROBOT"
        }


class BuildConfigsWithPva(Cube):
    TYPE = TYPE_BUILD

    def __init__(self, new_tag_cube):
        self._new_tag_cube = new_tag_cube

        super(BuildConfigsWithPva, self).__init__(
            name="build_configs_with_pva",
            task="projects/upper_search/noapache/build_configs_with_pva",
            needs=[new_tag_cube],
        )

    @property
    def input_defaults(self):
        return {
            "arcadia_url": "{}/arcadia".format(
                CubeInput.format_cube_output_value(self._new_tag_cube.output.svn_data.svn_paths.tag)
            ),
            "config_types": "\n".join([
                "NOAPACHE_PRODUCTION_INSTANCECTL_CONF",
                "NOAPACHE_HAMSTER_INSTANCECTL_CONF",
                "NOAPACHE_PUSHCLIENT_PRODUCTION_CONF",
                "NOAPACHE_PUSHCLIENT_HAMSTER_CONF",
            ]),
        }
