from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.components.config_core.jg.cube import base as cube_base


TYPE_GENERATE_BETA = "generate_beta"


class GenerateYappyBeta(cube_base.Cube):

    TYPE = TYPE_GENERATE_BETA
    TASK = "GENERATE_YAPPY_BETA"

    def __init__(self, component_name, beta_conf_type, **kwargs):

        self._component_name = component_name
        self._beta_conf_type = beta_conf_type

        kwargs["task"] = self.TASK

        super(GenerateYappyBeta, self).__init__(**kwargs)

    @property
    def component_name(self):
        return self._component_name

    @property
    def beta_conf_type(self):
        return self._beta_conf_type

    @property
    def input_defaults(self):
        return {
            "component_name": self._component_name,
            "beta_conf_type": self._beta_conf_type,
            "release_number": rm_const.CIJMESPathCommon.MAJOR_RELEASE_NUM,
        }

    def _construct_name(self):
        return "{cube_type}__{component_name}__{beta_conf_type}".format(
            cube_type=self.TYPE,
            component_name=self._component_name,
            beta_conf_type=self._beta_conf_type,
        ).lower()
