from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import build as build_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import dummy as dummy_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube import base as cube_base


class ApphostVerticalJGCfg(basic_build_presets.SingleBuildGeneralJGCfg):
    build_task = "BUILD_HORIZON_AGENT_CONFIG"

    @property
    def vertical_name(self):
        raise NotImplementedError

    @property
    def add_beta_generator(self):
        return bool(self.root_cfg.yappy_cfg.betas)

    def _get_build_cube(self, graph):

        new_tag = graph.get("new_tag")

        build = build_cubes.BuildHorizonAgentConfig(
            name="build_horizon_agent_config",
            title="Build Horizon Agent Config",
            vertical=self.vertical_name,
            arc_tag=cube_base.CubeOutputTransformed(
                [
                    new_tag.output.vcs_data.arc.tag_path,
                ],
                lambda l: "arcadia-arc:/#{}".format(*l),
            ),
            needs=[
                graph.get(dummy_cubes.RMMainGraphEntry.NAME),
            ],
        )

        return build

    def _check_releasable_item_is_suitable(self, ri):
        return hasattr(ri.data, "resource_type")
