import pytest

from sandbox.projects.release_machine.core import const as rm_const

from sandbox.projects.release_machine.components.config_core.bases.ci import ReferenceCIConfig
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
from sandbox.projects.release_machine.components.config_core.jg import base as jg_base

from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets
from sandbox.projects.release_machine.core import releasable_items as ri


class SingleBuildPresetTestCfg(ReferenceCIConfig):
    name = "test_component"
    responsible = "robot-srch-releaser"

    class CI(ReferenceCIConfig.CI):
        secret = "abcdefghij"
        sb_owner_group = "XXXXXX"
        a_yaml_dir = "whatever/suits/the/test/needs"

    class JG(basic_build_presets.SingleBuildYaMakeJGCfg):
        add_beta_generator = True

    class Releases(ReferenceCIConfig.Releases):

        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="iceflame_binary",
                    data=ri.SandboxResourceData(
                        "ICEFLAME_BINARY",
                    ),
                    deploy_infos=[
                        ri.SandboxKosherReleaseInfo(stage=rm_const.ReleaseStatus.stable),
                    ],
                    build_data=ri.BuildData(
                        target="release_machine/iceflame/bin",
                        artifact="release_machine/iceflame/bin/iceflame",
                    ),
                ),
            ]

    class Yappy(ReferenceCIConfig.Yappy):

        betas = {
            "beta": yappy_cfg.YappyTemplateCfg(
                template_name="test_template",
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir="test_patch_dir",
                        resources=[
                            yappy_cfg.YappyParametrizedResource(
                                local_path="test_local_path",
                                param_name="test_param_Name",
                            ),
                        ],
                        parent_service="test_parent_service",
                    ),
                ],
            ),
        }


@pytest.fixture(scope="module")
def cfg():
    return SingleBuildPresetTestCfg()


def test__basic_build_preset_job_graph(cfg):

    assert hasattr(cfg, "jg")
    assert isinstance(cfg.jg, jg_base.JGCfg)
    assert len(cfg.jg.non_release_actions) == 0
    assert len(cfg.jg.release_actions) == 1
    assert "release_test_component" in cfg.jg.release_actions

    release_flow = cfg.jg.release_actions["release_test_component"]

    assert not release_flow.action_parameters.auto
    assert release_flow.action_parameters.triggers is None

    assert release_flow.action_parameters.branches is not None
    assert release_flow.action_parameters.branches.pattern == cfg.svn_cfg.arc_branch_path("${version}")
    assert release_flow.action_parameters.branches.auto_create is True
    assert not release_flow.action_parameters.branches.forbid_trunk_releases

    branches_dict = release_flow.action_parameters.branches.to_dict()

    assert "pattern" in branches_dict
    assert "auto-create" in branches_dict
    assert "forbid-trunk-releases" in branches_dict

    all_cube_names = {c.name for c in release_flow.graph.all_cubes_iter}

    assert all_cube_names == {
        "release_stable_kosher_sandbox_release", "build", "new_tag", "create_changelog",
        "create_startrek_ticket", "link_feature_tickets", "format_changelog", "post_changelog_to_startrek",
        "generate_beta__test_component__beta",
        "release_stage_entry", "main_graph_entry",
    }


def test__generate_yappy_beta_cube(cfg):
    release_flow = cfg.jg.release_actions["release_test_component"]

    generate_yappy_beta = release_flow.graph.get("generate_beta__test_component__beta")
    build = release_flow.graph.get("build")
    release_stage_entry = release_flow.graph.get("release_stage_entry")
    release = release_flow.graph.get("release_stable_kosher_sandbox_release")

    assert build in generate_yappy_beta.requirements
    assert generate_yappy_beta in release_stage_entry.requirements
    assert release_stage_entry in release.requirements
