from sandbox.projects.release_machine.components.config_core.jg.preset.basic_build_presets import JOINED_BUILD_RELEASE_FLOW_STAGES
from sandbox.projects.release_machine.components.config_core.jg import base as jg_base
from sandbox.projects.release_machine.components.config_core.jg import flow as jg_flow
from sandbox.projects.release_machine.components.config_core.jg.cube.lib.upper_search.noapache import build
from sandbox.projects.release_machine.components.config_core.jg.cube.lib.upper_search.noapache import noapache_tests


class ReleaseNoapacheJG(jg_base.BaseReleaseMachineJobGraph):
    @property
    def search_integration_tests_bundle(self):
        raise NotImplementedError

    @jg_flow.release_flow(stages=JOINED_BUILD_RELEASE_FLOW_STAGES)
    def release(self):
        graph = super(ReleaseNoapacheJG, self).release(self)

        new_tag = graph.get("new_tag")

        web_beta = "?"  # TODO

        # build part
        build_noapache = build.BuildNoapacheUpper(new_tag)
        build_rearrange = build.BuildRearrange(new_tag)
        build_rtcc_bundle = build.BuildRtccBundle(new_tag)
        build_rearrange_fast = build.BuildRearrangeDataFast(new_tag)
        build_instancectl = build.BuildConfigsWithPva(new_tag)

        build_cubes = [build_noapache, build_rearrange, build_rtcc_bundle, build_rearrange_fast, build_instancectl]  # noqa

        # tests part
        blender_performance_vs_prod = noapache_tests.TestCompareMiddleSearchBinaries(build_noapache, build_rearrange, build_rearrange_fast)
        test_rtcc_diff = noapache_tests.TestRtccDiff(new_tag, build_rtcc_bundle)
        test_empty_experiment = noapache_tests.TestEmptyExperimet(new_tag, build_noapache, build_rearrange, web_beta)
        launch_arcadia_tests_rearrange_dynamic = noapache_tests.LaunchArcadiaTestsForRearrangeDynamic(new_tag)

        tests_cubes = [blender_performance_vs_prod, test_rtcc_diff, test_empty_experiment, launch_arcadia_tests_rearrange_dynamic]  # noqa

        return graph
