import six
from enum import Enum
from sandbox.projects.release_machine.components.config_core.jg.cube import base as jg_cube
from sandbox.projects.release_machine.components.config_core.jg.preset import exceptions as preset_exceptions
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import release as release_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import dummy as dummy_cubes
from sandbox.projects.release_machine.components.config_core.jg import flow as jg_flow
from sandbox.projects.release_machine.components.config_core.jg.graph import base as graph_base
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets
from sandbox.projects.release_machine.components.config_core.jg.cube.lib.upper_search.base import IceFlamePatched
from sandbox.projects.release_machine.components.config_core.jg.cube.lib.upper_search.base.yappy import GenerateYappyBetaUpperSearch
from sandbox.projects.release_machine.components.config_core.jg.cube.lib.upper_search.base import SearchReleasesBuildTestCube


class UpperSearchSanitizerTests:
    def __init__(self, targets, sanitizers, needs):  # targets: list, sanitiziers: list, needs: List[Cube]
        if not isinstance(targets, list) or not isinstance(sanitizers, list):
            raise TypeError("targets and sanitiziers should be lists!")

        self._targets = targets
        self._sanitizers = sanitizers
        self._needs = needs

    @property
    def targets(self):
        return self._targets

    @property
    def sanitizers(self):
        return self._sanitizers

    @property
    def bundle(self):
        return [
            SearchReleasesBuildTestCube(
                name="ya_make_{}_sanitizer_test".format(sanitizer) if sanitizer else "ya_make_diff_test",
                needs=self._needs,
                input=jg_cube.CubeInput(
                    targets=";".join(self.targets),
                    sanitize=sanitizer,
                ),
            ) for sanitizer in self.sanitizers
        ]


class UpperSearchBetaTests:
    def __init__(self, beta_tests):  # tests: List[Cube]
        self._beta_tests = beta_tests

    @property
    def beta_tests(self):
        return self._beta_tests

    @property
    def bundle(self):
        return self.beta_tests


class UpperSearchSingleBuildYaMakeJGCfg(basic_build_presets.SingleBuildYaMakeJGCfg):
    def __init__(self, *args, **kwargs):
        self._releases_cfg = kwargs.pop("releases_cfg")
        super(UpperSearchSingleBuildYaMakeJGCfg, self).__init__(*args, **kwargs)

    @property
    def release_flow_params(self):
        return {}

    @property
    def morty_config(self):
        return {}

    class MortyConfig(Enum):
        nanny_dashboard_flow = 0
        warden_component_name = 1
        warden_parent_component_name = 2

    def is_morty_enabled(self):
        if self.morty_config:
            assert sorted(self.morty_config.keys()) == sorted(
                [self.MortyConfig.nanny_dashboard_flow.name, self.MortyConfig.warden_component_name.name, self.MortyConfig.warden_parent_component_name.name]
            ), '"{}", "{}", "{}" are necessary in morty_config!'.format(
                self.MortyConfig.nanny_dashboard_flow.name, self.MortyConfig.warden_component_name.name, self.MortyConfig.warden_parent_component_name.name
            )
            assert all(self.morty_config.values()), "Empty values in morty_config!"
            assert [item for item in self._releases_cfg.releasable_items if item.data.resource_type == "SCHEDULED_RM_RELEASE_DATA"], "No SCHEDULED_RM_RELEASE_DATA for Morty in releasable_items!"
            return True
        return False

    @property
    def iceflame_nanny_service(self):
        return ""

    @property
    def iceflame_config_name(self):  # if exists - iceflame is on
        return ""

    @property
    def sanitizer_tests_targets(self):
        return []

    @property
    def sanitizer_tests_sanitizers(self):
        return []

    def _get_beta_tests_bundle(self, graph):
        return []

    def _get_generate_yappy_beta_cubes(self, graph, build):

        if not self.add_beta_generator:
            # LOGGER.info("add_beta_generator = False => no yappy generator is going to be added")
            return []

        if not isinstance(self.add_beta_generator, six.string_types):
            raise TypeError("add_beta_generator should be string!")

        if not self.root_cfg.yappy_cfg.betas:
            raise preset_exceptions.JGPresetUsageError(
                "add_beta_generator is set to True but no suitable Yappy configuration provided. Please provide one "
                "in the Yappy section of {}'s config file".format(self.root_cfg.name),
            )

        if not build:
            raise preset_exceptions.JGPresetUsageError(
                "In order to add a GenerateYappyBeta cube you should add a build cube first. No cube with name "
                "'build' can be found among graph cubes {}".format(
                    ", ".join([str(cube) for cube in graph.all_cubes_iter]),
                ),
            )

        return [
            GenerateYappyBetaUpperSearch(
            component_name=self.component_name,
            beta_conf_type=self.add_beta_generator,
            input=jg_cube.CubeInput(
                component_resources={
                    ri.name: build.output.resources[ri.data.resource_type].first().id
                    for ri in self.suitable_releasable_items
                },
            ),
            needs=[build],
        )
        ]

    def _get_release_cubes_for_deploy_system(self, deploy_system, where, releasable_items, graph, build):
        return [
            release_cubes.ScheduleRelease(
                name="release_{}_{}".format(where, deploy_system),
                component_name=self.component_name,
                where_to_release=where,
                flows=[self.morty_config[self.MortyConfig.nanny_dashboard_flow.name]],
                warden_component_name=self.morty_config[self.MortyConfig.warden_component_name.name],
                warden_parent_component_name=self.morty_config[self.MortyConfig.warden_parent_component_name.name],
                deploy_system=deploy_system,
                schedule_mode="create_and_schedule",
                input=jg_cube.CubeInput(
                    component_resources={
                        ri.name: build.output.resources[ri.data.resource_type].first().id
                        for ri in releasable_items
                    },
                ),
                manual=self.release_manually,
            ),
        ] if self.is_morty_enabled() else [
            release_cubes.ReleaseRmComponent2(
                name="release_{}_{}".format(where, deploy_system),
                component_name=self.component_name,
                task=self.release_task,
                where_to_release=where,
                input=jg_cube.CubeInput(
                    component_resources={
                        ri.name: build.output.resources[ri.data.resource_type].first().id
                        for ri in releasable_items
                    },
                    deploy_system=deploy_system,
                ),
                manual=self.release_manually,
            )
        ]

    @jg_flow.release_flow(
        stages=basic_build_presets.JOINED_BUILD_RELEASE_FLOW_STAGES,
    )
    def release(self):
        if self.release_flow_params:
            for param, value in self.release_flow_params.items():
                self.release._register_params[param] = value

        graph = super(UpperSearchSingleBuildYaMakeJGCfg, self).release(self)

        release_entry_cube = graph.get(dummy_cubes.ReleaseStageEntry.NAME)

        # sanitizer tests init
        sanitizer_tests = UpperSearchSanitizerTests(
            targets=self.sanitizer_tests_targets,
            sanitizers=self.sanitizer_tests_sanitizers,
            needs=[graph.get(dummy_cubes.RMMainGraphEntry.NAME)]
        )

        # beta tests init
        beta_tests = UpperSearchBetaTests(
            beta_tests=self._get_beta_tests_bundle(graph)
        )

        # add cubes to graph
        for test in sanitizer_tests.bundle + beta_tests.bundle:
            release_entry_cube.add_requirement(test)
            graph.add(test)

        return graph

    @jg_flow.register_flow(title="Run IceFlame")
    def run_iceflame(self):
        if self.iceflame_config_name:
            if hasattr(self._releases_cfg, "releasable_items") and len(self._releases_cfg.releasable_items) > 0:
                release_item_name = self._releases_cfg.releasable_items[0].name
            else:
                release_item_name = ""

            return graph_base.Graph(
                [IceFlamePatched(self.component_name, release_item_name, self.iceflame_nanny_service, self.iceflame_config_name)]
            )
