from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.common.constants import constants as common_const


class DeployServicesInfo(object):
    __slots__ = ("services", "dashboards", "level", "chooser")

    def __init__(self, services, dashboards=None, level=rm_const.ReleaseStatus.stable, chooser=max):
        """
            :param level: "stable", "testing" etc
            :param services: list of services to deploy
            :param dashboards: list of dashboards to deploy
            :param chooser: function to choose DeployServicesInfo in list
        """
        self.level = level
        self.services = services
        self.dashboards = dashboards or []
        self.chooser = chooser

    def __lt__(self, other):
        return (
            "{}_{}".format(self.level, "_".join(sorted(self.services)))
            <
            "{}_{}".format(other.level, "_".join(sorted(other.services)))
        )

    def __eq__(self, other):
        return (
            self.level == other.level and
            set(self.services) == set(other.services) and
            set(self.dashboards) == set(other.dashboards) and
            self.chooser == other.chooser
        )

    def __str__(self):
        return "DeployInfo<{}> (services = {}, dashboards = {})".format(self.level, self.services, self.dashboards)

    __repr__ = __str__


class ReleasedResourceInfo(object):
    def __init__(
        self, name,
        resource_type,
        resource_name=None,
        build_ctx_key=common_const.ARCADIA_URL_KEY,
        attributes=None,  # Could be like {"resource_name": "yandex-search-ab-testing"}
        deploy=None,  # [("stable", "nanny_service1"), ("testing", "nanny_service2")] or [DeployServicesInfo(), ]
    ):
        """
            :param name: Arbitrary identifier of release item
            :param resource_type: Resource type
            :param resource_name: Should be different from other resource's names
            because it used to get correct resource type class
            :param build_ctx_key: Input or Context parameter which defines the path to build resource from
            :param attributes: Attributes to distinguish resources with same resource_name (ex. YA_PACKAGE). RMDEV-488
        """
        self.name = name
        self.resource_type = resource_type
        self.resource_name = resource_name or name
        self.build_ctx_key = build_ctx_key
        self.attributes = attributes
        self.deploy = deploy

    def to_json(self):
        return self.__dict__

    def __str__(self):
        return "ReleasedResource {} <{}>".format(self.name, self.resource_type)
