# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs as cfg
# from sandbox.projects.release_machine.core import const as rm_const
# from sandbox.projects.release_machine.config_core import release_block


class ComponentNameCfg(cfg.ReferenceBranchedConfig):
    """
    Configuration template for components with branched release cycle.

    All properties that are NOT commented are mandatory.
    Commented properties and methods are optional.
    """

    # Component main identifier.
    #
    # Requirements:
    # - Must be unique
    # - Must follow PEP8 [function and variable naming convention]
    # (https://www.python.org/dev/peps/pep-0008/#function-and-variable-names)
    #
    # Example: `"my_shiny_component"`
    name = ""

    # # Display name of the component shown in UI
    # #
    # # Example: `"My Shiny Component"`
    # display_name = ""

    # Username of the person responsible for the component or
    # namedtuple with abc group and login of person who is responsible for releases of the component
    # (role_id and scheduled_slug are optional)
    #
    # Example 1: `"jondoe"`
    # Example 2: cfg.Responsible(abc=cfg.Abc(component_id=1, role_id=1, schedule_slug=None), login="login")
    responsible = ""

    # class MergesCfg(cfg.ReferenceBranchedConfig.MergesCfg):
    #     # never_merge_to_released_branches = False
    #     # number_last_branches_to_merge = 2

    #     # # Merge permissions
    #     # # Define people groups to ban or to allow merges into stable branches
    #     # # Default: allow to all
    #     # permissions = cfg.MergePermissions(
    #     #     permission_type=rm_const.PermissionType.ALLOWED,  # or rm_const.PermissionType.BANNED
    #     #     people_groups=cfg.PeopleGroups(
    #     #         staff_groups=['yandex_search_tech_quality_component_8875'],
    #     #         abc_services=[cfg.Abc(component_id=2100, role_id=None)],
    #     #         logins={"login1", "login2"},
    #     #     ),
    #     # )

    class Testenv(cfg.ReferenceBranchedConfig.Testenv):
        """
        TestEnv configuration settings
        """

        # Your team sandbox-group
        #
        # This sandbox group will be set as task owner for tasks run by TestEnv
        #
        # Example: `"SEARCH-RELEASERS"`
        trunk_task_owner = ""

        # # List of logins that should be added to testenv trunk db
        # # Used in PrepareRmComponentEnvironment and CloneTestenvDb
        # #
        # # Example: `['mvel', 'glebov-da', 'ilyaturuntaev']`
        # #
        # # Default: `[]`
        # testenv_db_owners = []

        # # todo: Add description
        # # Nobody knows the true purpose of this setting...
        # #
        # last_good_revision_ignore_release_jobs = False

        # # TestEnv trunk DB
        # #
        # # Default: `"{name}-trunk".format(name=name)`
        # trunk_db = ""

        # # Testenv branch DB template
        # #
        # # Should include a 'testenv_db_num' named replacement
        # #
        # # Default: `"{name}-{{testenv_db_num}}".format(name=name)`
        # branch_db_template = ""

        # # Testenv main DB template
        # #
        # # Should include one positional replacement (will be replaces with component name)
        # #
        # # Default: `branch_db_template`
        # db_template = ""

        # # A regular expression used to match branch DBs in Testenv.
        # # If you customize `branch_db_template` you should alter this
        # # property accordingly as well
        # #
        # # Default: `re.compile(name + r"-([0-9]+)")`
        # branch_db_regex = re.compile("")

        # # Returns a range of branch numbers for branch DBs that should
        # # be dropped when creating a new branch DB for the given
        # # `branch_number`
        # #
        # @staticmethod
        # def db_drop_range(branch_number):
        #     return super(self.__class__, self).db_drop_range(branch_number)

        # # Returns a range of branch numbers for branch DBs that should
        # # be stopped when creating a new branch DB for the given
        # # `branch_number`
        # #
        # @staticmethod
        # def db_stop_range(branch_number):
        #     return super(self.__class__, self).db_stop_range(branch_number)

        # # Read our documentation for better understanding https://wiki.yandex-team.ru/ReleaseMachine/JobGraph/
        # class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
        #     @property
        #     def _branch_part(self):
        #         """
        #             Part of job graph for Testenv with jobs in branch, i.e. tests, builds.
        #             :return: list with jobs
        #         """
        #         branch_part = super(self.__class__, self)._branch_part
        #         branch_part.append(
        #             jg_build.JobGraphElementBuildBranched(
        #                 task_name="YA_MAKE_2",                                # Task to launch in this job
        #                 out={"BINARY": 180},                                  # Resource which task YA_MAKE_2 build
        #                 ctx={                                                 # Context fields to put in YA_MAKE_2 task
        #                     "targets": "my/target/folder",
        #                     "arts": "my/target/folder/file_name",
        #                 },
        #                 job_arrows=(                                          # Arrows to other jobs
        #                     jg_job_triggers.JobTriggerNewTag(                 # Arrow to job NewTag
        #                         parent_job_data=(                             # Fields to get from NewTag job and put in Build job
        #                             # Get "scope_number" from Context and put in "release_number" input field. Override means that we already have this field as default, and we want to override it.
        #                             jg_job_data.ParentDataCtx("release_number", "scope_number", override=True),
        #                             jg_job_data.ParentDataId("tag"),          # Put NewTag task id in input field "tag"
        #                         ),
        #                     )
        #                 ),
        #             ),
        #         )
        #         return branch_part
        #
        #     @property
        #     def _release(self):
        #         """
        #             Release part of job graph for Testenv with arrows and dependencies
        #             :return: list with jobs
        #         """
        #         release_part = super(self.__class__, self)._release
        #         for release_stage in [rm_const.ReleaseStatus.testing, rm_const.ReleaseStatus.stable]: # We want to have two types of releases - "stable" and "testing"
        #             release_part.append(jg_release.JobGraphElementReleaseBranched(
        #                 release_to=release_stage,                                                     # Which type of release use
        #                 job_arrows=(
        #                                                                               # Put in input field "input_res" id of resource "MY_BEAUTIFUL_RESOURCE", which should exist in testenv base
        #                     jg_arrows.GlobalResourceData("input_res", "MY_BEAUTIFUL_RESOURCE"),
        #                     jg_arrows.ParentsData(                                                    # Class to combine some parameters in one value
        #                         input_key="build_info",                                               # Where to put the result of combination
        #                         triggers=(                                                            # From where get parameters to combine
        #                             jg_job_triggers.JobTriggerBuild(
        #                                 parent_job_data=(
        #                                     jg_job_data.ParentDataCtx("resource_id", "arts"),         # Get "arts" from Build task context and save in dict as "resource_id"
        #                                 ),
        #                             ),
        #                             jg_job_triggers.JobTriggerNewTag(
        #                                 parent_job_data=(
        #                                     jg_job_data.ParentDataCtx("result_url", "result_url"),    # Get "result_url" from NewTag task context and save in dict as "result_url"
        #                                 ),
        #                             ),
        #                         ),
        #                         transform=lambda resource_id, result_url: "Build resource with id {id} from url {url}".format(id=resource_id, url=result_url),  # Combine parameters from dict
        #                     ),
        #                     jg_job_triggers.JobTriggerBuild(
        #                         parent_job_data=(
        #                             # Put resource id from resource "BINARY" of build job to dict "component_resources"
        #                             # Resource "BINARY" must be declared as "out" in build job graph element
        #                             jg_job_data.ParentDataDict("component_resources", "binary", "BINARY"),
        #                         ),
        #                     ),
        #                     jg_job_triggers.JobTriggerNewTag(
        #                         parent_job_data=(
        #                             jg_job_data.ParentDataCtx("release_number", "scope_number", override=True),
        #                         ),
        #                     ),
        #                 ),
        #             ))
        #             release_part.append(jg_release.JobGraphElementActionReleaseBranched(
        #                 release_to=release_stage,
        #                 job_arrows=(
        #                     jg_job_triggers.JobTriggerRelease(job_name_parameter=release_stage),
        #                     jg_job_triggers.JobTriggerChangelogFinal(),
        #                 ),
        #             ))
        #         return release_part

        # class JobPatch(cfg.ReferenceBranchedConfig.Testenv.JobPatch):
        #
        #     # List of jobs that should be deactivated in cloned DB
        #     deactivate = []
        #
        #     @property
        #     def change_frequency(self):
        #         """
        #         Use this to change default frequencies of your jobs in branch
        #         DB
        #         """
        #         tests = super(self.__class__, self).change_frequency
        #         # tests.update({...})  # Update the default with your custom settings
        #         return tests
        #
        #     @property
        #     def ignore_match(self):
        #         """
        #         List of names of TestEnv jobs that should be ignored in
        #         branch DB
        #         """
        #         common_ignored = super(self.__class__, self).ignore_match
        #         return common_ignored + [...]  # Add something if needed
        #
        #     @property
        #     def ignore_prefix(self):
        #         """List of job prefixes that should be ignored in branch DB"""
        #         common = super(self.__class__, self).ignore_prefix
        #         return common + [...]  # Add something if needed
        #

    class Notify(cfg.ReferenceBranchedConfig.Notify):
        """ Notification settings """

        # # Whether to use Startrek stuff or not
        # #
        # # Set to False if you don't want any Startrek-related functionality
        # # provided by RM for your component. With `use_startrek = False`
        # # you don't have to provide any Startrek configuration.
        # #
        # # Default: `True`
        # use_startrek = True

        # class Mail(cfg.ReferenceBranchedConfig.Notify.Mail):
        #     """ Mail notifications """
        #
        #     # # Mailing list
        #     # #
        #     # # A list of email addresses that should receive email notifications
        #     # #
        #     # # Default = `["search-components-releases"]`
        #     # mailing_list = ["search-components-releases"]

        # class Telegram(cfg.ReferenceBranchedConfig.Notify.Telegram):
        #     """ Telegram notifications """
        #
        #     # # Read more about RM notifications on https://wiki.yandex-team.ru/releasemachine/notifications/
        #
        #     # # Telegram chat
        #     # #
        #     # # Name of the Telegram chat as defined in `projects/common/release_machine/core/const/__init__.py`.
        #     # # This chat will receive various notifications
        #     # #
        #     # # Example: `"rm_maintainers"`
        #     # #
        #     # # Default: `[]`
        #     # chats = []
        #
        #     # # Your Telegram chat invite link
        #     # #
        #     # # Example: `"https://t.me/joinchat/AAAAAEN49wUGP2uImQ6Dfw"`
        #     # #
        #     # # Default: `None`
        #     # invite_link = None

        class Startrek(cfg.ReferenceBranchedConfig.Notify.Startrek):
            """
            Startrek notifications

            https://wiki.yandex-team.ru/releasemachine/startrekoptions/
            """

            # Assignee of Startrek ticket at the creation time
            #
            # Username of the person the newly created release ticket should be assigned to.
            # See `assignee_after_acceptance` if you want to assign tickets to another person after acceptance.
            #
            # Example: `"lebedev-aa"`
            assignee = ""

            # Name of the Startrek release queue
            #
            # Your release ticket will be created in this queue.
            #
            # Example: `"RMTEST"`
            queue = ""

            # Name of the Startrek development queue
            #
            # Used for complain tickets
            #
            # Example: `"RMDEV"`
            dev_queue = ""

            # Ticket summary template (formatstring)
            #
            # A formatstring for ticket header in Startrek. Should include one (and only one) no-name
            # replacement field (i.e., `"{}"`). The result summary is built like this:
            # `summary_template.format(release_num)` (where `release_num` is a release number).
            #
            # Example: `"My component acceptance {}"`
            summary_template = ""

            # # Variable to choose order of merged revisions
            # #
            # # Used for logging merges in startrek
            # #
            # # Default: rm_const.SortOrder.ASCENDING
            # #
            # # Another option: rm_const.SortOrder.DESCENDING
            #
            # merged_revisions_order = rm_const.SortOrder.ASCENDING

            # # Whether to send notifications when robot creates or updates comments in Startrek ticket.
            # #
            # # When set to False, ticket subscribers will not receive email notifications when Release Machine robot posts a comment or updates an existing one.
            # #
            # # This option does not affect human-made comments and ticket status updates.
            # #
            # # Default: False
            # #
            # # Another option: True
            #
            # notify_on_robot_comments_to_tickets = False

            # # Assignee of Startrek ticket after release acceptance
            # #
            # # Username of the person who should be set as assignee of release ticket **after** acceptance.
            # #
            # # Default: `assignee`
            # #
            # # Example: `"lebedev-aa"`
            # assignee_after_acceptance = assignee

            # # List of ticket components
            # #
            # # See https://wiki.yandex-team.ru/tracker/vodstvo/versionscomponents/#komponenty for more
            # # information on Startrek ticket components.
            # # Either a list of unicode strings or a single unicode string or None.
            # #
            # # Default: `None`
            # #
            # # Examples:
            # # - `None`
            # # - `u"st component name"`
            # # - `u"название компоненты".encode('utf-8')`
            # # - `[u"st component name", u"название компоненты".encode('utf-8')]`
            # components = None

            # # List of Startrek ticket follower
            # #
            # # List of usernames of persons that should be set as release ticket followers
            # #
            # # Default: `[assignee]`
            # #
            # # Example1: `['gautama', 'kassapa', 'konagamana', 'kakusandha', 'vessabhu', 'sikhi', 'vipassi']`
            # # Example2:
            # # ```
            # # followers = configs.PeopleGroups(
            # #     staff_groups=['yandex_search_tech_quality_component_8875'],
            # #     abc_services=[configs.Abc(component_id=2100, role_id=None)],
            # #     logins={"login1", "login2"},
            # # )
            # # ```
            # followers = [assignee]

            # # Startrek ticket type
            # #
            # # If not None, the value should be a valid ticket type title for the given `queue`.
            # # https://wiki.yandex-team.ru/tracker/vodstvo/issue/#kakiepoljaestvtikete
            # #
            # # Examples:
            # # - `"bug"`
            # # - `None`
            # ticket_type = None

            # # Ticket tags
            # #
            # # List of tags that should be assigned to release tickets.
            # # The default value consists of 'rm_main_ticket' and the component name.
            # # For more information, see https://wiki.yandex-team.ru/tracker/vodstvo/versionscomponents/#tegi
            # #
            # # Default: `['rm-main-ticket', <name>]`
            # tags = ['rm-main-ticket', name]

            # # Startrek workflow
            # #
            # # Defines rules for a release ticket status transformation. Release Machine is capable of
            # # changing a ticket status depending on a stage of release. This property is used to map
            # # stages to release ticket statuses.
            # #
            # # For more information on Startrek ticket workflows see
            # # https://wiki.yandex-team.ru/tracker/vodstvo/workflows/
            # #
            # # Default: `{}`
            # #
            # # Example:
            # # ```
            # # workflow = {
            # #     "open": "autoTesting",
            # #     "fixProblems": "accepting",
            # #     "production": "close",
            # #     "closed": "reopen",
            # #     "qualityOK": "deploying",
            # #     "accepting": "qualityOK",
            # #     "autoTesting": "autoTestsOK",
            # #     "autoTestsOK": "accepting",
            # #     "deploying": "production",
            # # }
            # # ```
            # workflow = {}

            # # Whether to use release task author as ticket assignee upon creation
            # #
            # # When set to `True`, the value of `assignee` is ignored and the task author is set as
            # # ticket assignee. Change to `False` if you'd like to always use the `assignee` value.
            # #
            # # Default: `True`
            # use_task_author_as_assignee = True

            # # Whether to hide change table under cut in release ticket comment
            # #
            # # When set to `True` will wrap commits table in a collapsible elemnt
            # #
            # # Default: `False`
            # hide_commits_under_cut = False

            # # Whether to write notifications on deployment to feature tickets
            # #
            # # Works with major releases only. When set to `True` writes a notification comment to the relevatn
            # # feature tickets upon every deployment
            # #
            # notify_on_deploy_to_feature_st_tickets = False

            # # Threshold for commit importance
            # #
            # # This property forces RM to take only those changelog entries
            # # with importance >= `commit_importance_threshold` when building a description of a Startrek ticket
            # #
            # # Default: `2`
            # commit_importance_threshold = 2

            # # Limit for important changelog entries
            # #
            # # Defines an upper bound for the number of changelog entries with importance level >=
            # # `commit_importance_threshold` that would appear in release ticket description
            # #
            # # Default: `60`
            # important_changes_limit = 60    # Limit important changes

            # # Whether to add commit authors as followers of release tickets
            # #
            # # Default: `True`
            # add_commiters_as_followers = True

            # # Write Nanny reports
            # #
            # # Whether to post Nanny's release reports in Startrek release tickets
            # # Spam alert! You don't want it if you've got too many services
            # #
            # # Default: `True`
            # nanny_reports = True

            # # Ticket deadline (in days since ticket creation)
            # #
            # # The amount of days since ticket creation until it has to be resolved.
            # # The actual deadline date is roughly equal to
            # # `datetime.datetime.now() + datetime.timedelta(days=deadline)` (where *now* is the time of
            # # ticket creation)
            # #
            # # Default: `3`
            # deadline = 3

            # # Set of ignored Startrek queues
            # #
            # # When calculating a list of release ticket followers RM will skip all tickets
            # # that belong to any of the `banned_queues`. This means that an author of a commit
            # # related to a ticket in a banned queue won't be added to the list of the release ticket
            # # followers unless he hadn't published any commit related to a ticket in a not-banned queue.
            # #
            # # Default: `{"IGNIETFERRO", "SUBBOTNIK"}`
            # banned_queues = {"MY_QUEUE"}

            # # Set of banned people
            # #
            # # Defines a set of usernames of people that should not be added as release ticket followers.
            # # These people will never be added as release ticket followers regardless their relevance
            # # to the release.
            #
            # @property
            # def banned_people(self):
            #     return super(self.__class__, self).banned_people | {"additional_logins"}

            # # Close resolved tickets linked to release ticket.
            # #
            # # Used in ReleaseRmComponent
            # #
            # # Default: `False`
            # close_linked_tickets = False

            # # Whether to join all merges in one table or split them in separate comments
            # #
            # # Sometimes users don't want to see one table for all merged commits,
            # # they want to see new comment for each merge. In this case write_merges_in_table should be `False`.
            # # When `True`, all merges are combined in one table in one comment
            # #
            # # Default: `True`
            # write_merges_in_table = True

    class ChangelogCfg(cfg.ReferenceBranchedConfig.ChangelogCfg):
        """
        Changelog configuration

        https://wiki.yandex-team.ru/releasemachine/changelogs/
        """

        # Directories to get changelog revisions from
        #
        # Defines a list of SVN paths that will be used to obtain changelog from (via `SVN log`).
        # If empty then the log is obtained from 'arcadia:/arc/trunk'.
        # todo: Path format seems to be not fixed -- find out and present actual format here
        #
        # Example:
        # ```
        # [
        #     "arcadia/sandbox/projects/common/search/release_web",
        #     "arcadia/sandbox/projects/common/release_machine",
        # ]
        # ```
        dirs = []

        # Changelog wiki pages path
        #
        # Defines a path to the root directory of changelog wiki pages. It is often built in the following
        # format: 'jandekspoisk/kachestvopoiska/{component_name}/releases/' (where {component_name}) is
        # the component name. E.g., if you set `wiki_page = "jandekspoisk/kachestvopoiska/fourth_dhyana/releases/"`
        # then your changelog wiki pages' paths would look like
        # `"jandekspoisk/kachestvopoiska/fourth_dhyana/releases/stable-1"`,
        # `"jandekspoisk/kachestvopoiska/fourth_dhyana/releases/"stable-1/stable-1-1`, etc.
        #
        # Example: `"jandekspoisk/kachestvopoiska/fourth_dhyana/releases/"`
        wiki_page = ""

        # # Wiki page owner (defaults to the component's responsible)
        # #
        # # Username of the user who should possess read/write privileges to changelog wiki pages.
        # # Defaults to the `responsible` for the component
        # #
        # # Default: `responsible`
        # wiki_page_owner = ""

        # # Wiki page head template
        # #
        # # Formatstring for changelog wiki page header. Must include the following named replacement fields:
        # # - `descr` -- release path
        # # - `r1` -- first revision
        # # - `r2` -- last revision
        # # - `date` -- creation date
        # #
        # wiki_head_template = "===={descr} //r:{r1}-{r2}//\nCreation date: {date}"

        # # Changelog wiki page time-to-live in days
        # #
        # # Unless `None`, defines an amount of days for changelog wiki page to live.
        # # Wiki page is deleted after `wiki_page_ttl_days` passed since its creation.
        # # `None` means that pages should live forever.
        # #
        # # Default: `None`
        # wiki_page_ttl_days = None       # Remove wiki pages after this amount of days (don't if None)

        # # Changelog markers
        # #
        # # `list` or `None`
        # #
        # # Used to filter commits when building a changelog.
        # # When not `None` should define a list of tuples (importance, compiled_regexp)
        # # Only the commits with messages that match either of these
        # # regular expressions are added to the result changelog.
        # #
        # # If `markers` is `None` commit messages will not be parsed
        # #
        # # Example:
        # # ```
        # # [
        # #     (4, re.compile(r"\bdiff *: *(begemot|wizard)", flags=re.IGNORECASE)),
        # # ]
        # #```
        # #
        # # Default: `None`
        # markers = None

        # # Review groups scanned for commits
        # #
        # # This is used to get changelog from reviews. `review_groups` defines a list of
        # # Arcanum review group names. RM looks for commits in these groups and adds the
        # # appropriate info to changelog
        # #
        # # Example: `['review_group_1', 'review_group_2']`
        # #
        # # Default: `[]`
        # review_groups = []

        # # Skip changes for specific paths
        # # Default: `None`  # means, don't skip changes by paths
        #
        # # Take only changes which touch at least one path in "arcadia/path"
        # svn_paths_filter = ChangelogPathsFilter(rm_const.PermissionType.ALLOWED, ["arcadia/path"])
        #
        # # Skip changes which touch paths only from "arcadia/path"
        # svn_paths_filter = ChangelogPathsFilter(rm_const.PermissionType.BANNED, ["arcadia/path"])

        # @staticmethod
        # def calculate_importance(changelog_entry):
        #     """
        #     Calculate commit importance, which depends on commit paths.
        #     Default value is the mark of the given `changelog_entry`.
        #     """
        #     return cfg.ReferenceBranchedConfig.ChangelogCfg.calculate_importance(changelog_entry)

    # class SvnCfg(cfg.ReferenceBranchedConfig.SvnCfg):
    #     """
    #         Path to branches: /[REPO_NAME]/[branches_folder]/[branch_name]/[branch_folder_name]
    #         Path to tags: /[REPO_NAME]/[tag_folder]/[tag_name]/[tag_folder_name]
    #     """
    #     # # Max number of active branches
    #     # #
    #     # # Defines a limit for the number of latest branches a component can be released from.
    #     # #
    #     # # Default: `2`
    #     # max_active_branches = 2
    #
    #     # # Merge to released branches when use marker mergeto
    #     # #
    #     # # Overwrites merge_to_old_branches parameter in MergeToStable when mergeto marker is specified without
    #     # # branch numbers.
    #     # #
    #     # # Default: `False`
    #     # merge_to_old_branches = False
    #
    #     # # Whether to launch pre release process if new release was deployed from the last branch
    #     # #
    #     # # Default: `False`
    #     # allow_autobranches = False
    #
    #     # # Branch root folder
    #     # #
    #     # # /arc/{branches_folder}/...
    #     # #
    #     # # Default: `"branches"`
    #     # branches_folder = "branches"
    #
    #     # # Branch prefix
    #     # #
    #     # # Used to build branch folder pattern and branch folder name
    #     # #
    #     # # Default: `"stable"`
    #     # branch_prefix = "stable"
    #
    #     # # Branch name
    #     # #
    #     # # The name of the folder inside /arc/[branches_folder]/ where the branches reside
    #     # #
    #     # # Default: `name` (component name)
    #     # branch_name = ""
    #
    #     # # A format string that is used to build branch folder pattern, branch folder name, etc.
    #     # #
    #     # # `branch_folder_template` should define a valid Python format string with 2 named replacements:
    #     # # * `branch_prefix` -- replaced with the value of `branch_prefix`
    #     # # * `branch_num` -- replaced with either a branch number pattern or actual branch number
    #     # #
    #     # # Default: `"{branch_prefix}-{branch_num}"`
    #     # branch_folder_template = "{branch_prefix}-{branch_num}"
    #
    #     # # Tag root folder
    #     # #
    #     # # /arc/{tag_folder}/...
    #     # #
    #     # # Default: `"tags"`
    #     # tags_folder = "tags"
    #
    #     # # Tag prefix
    #     # #
    #     # # Used to build tag folder pattern and tag folder name
    #     # #
    #     # # Default: `"stable"`
    #     # tag_prefix = "stable"
    #
    #     # # Tag name
    #     # #
    #     # # The name of the folder inside /arc/[tags_folder]/ where the tags reside
    #     # #
    #     # # Default: `name` (component name)
    #     # tag_name = ""
    #
    #     # # A format string that is used to build tag folder pattern, tag folder name/ etc.
    #     # #
    #     # # `tag_folder_template` should define a valid Python format string with 3 optional
    #     # # named replacements:
    #     # # * `tag_prefix` -- replaced with the value of `tag_prefix`
    #     # # * `branch_num` -- replaced with either a branch number pattern or actual branch number
    #     # # * `tag_num` -- replaced with either a tag number pattern or actual tag number
    #     # #
    #     # # Note that any of the replacements in `tag_folder_template` can be omitted: e.g. you can
    #     # # define something like `"{tag_prefix}{tag_num}"` or whatever makes sense for your component
    #     # #
    #     # # Default: `"{tag_prefix}-{branch_num}-{tag_num}"`
    #     # tag_folder_template = "{tag_prefix}-{branch_num}-{tag_num}"

    class Releases(cfg.ReferenceBranchedConfig.Releases):
        # Releasable items
        # Contains information for production state monitoring.
        #
        # @property
        # def releasable_items(self):
        #     return [
        #         ri.ReleasableItem(
        #             name="my_releasable_item_unique_name",
        #             data=ri.SandboxResourceData("MY_SB_RESOURCE"),
        #             deploy_infos=[]  # here should be a list of deploy stages
        #         ),
        #     ]
        releasable_items = []

        # # Allow releases from older branches
        # #
        # # When set to `False` (default) helps preventing race conditions
        # # and occasional releases from obsolete branches
        # #
        # # Could be dict with release stages as key for fine tuning. Example
        # # allow_old_releases = {rm_const.ReleaseStatus.stable: False, rm_const.ReleaseStatus.testing: True}
        # #
        # # Default: `False`
        # allow_old_releases = False

        # # Whether to allow robot to release to stable
        # #
        # # When set to `True` allows automatic release to stable.
        # # Otherwise `ReleaseRMComponent` would not perform a stable
        # # release unless its author is a human being
        # #
        # # Default: `False`
        # allow_robots_to_release_stable = False

        # # A list of release followers
        # #
        # # Defines a list of usernames that should always be set as followers
        # # of release tickets
        # #
        # # Default: `[]`
        # release_followers_permanent = []

        # # Deploy system for the component
        # #
        # deploy_system = rm_const.DeploySystem.nanny

        # # Wait for deploy time (in seconds)
        # #
        # # How long should release task wait for component deployment
        # # before finishing
        # #
        # wait_for_deploy_time_sec = 4 * 60 * 60

        # # Block release depending on test results
        # #
        # # This option allows to set up some rules for release blocking based on the results of the tests.
        # # For more info on this option see
        # # https://wiki.yandex-team.ru/ReleaseMachine/Blokirovka-relizov/#blokirovkaporezultatamtestov
        # # For more info on ReleaseMachine Test Results see https://wiki.yandex-team.ru/releasemachine/testresults/
        # #
        # # `block` option specifies a list of blocking rules. One can construct such a rule using the
        # # `release_block.block_conf` function or otherwise using some of our predefined constants (see below).
        # # `release_block.block_conf` function takes in two arguments
        # # - `name_filter` -- defines a filter for test names to which the should be applied to; this can be either
        # #   a string (in which case the names will be matched using `fnmatch`) or a regex object (the names will
        # #   be matched using `re`)
        # # - `accept_result_threshold` -- if a test result status is greater than or equal to this threshold then
        # #   it is considered to be 'alright' (i.e., it should not block the release); the statuses are ordered in
        # #   the following way: OK > WARN > CRIT > ONGOING
        # # - `ignore_empty` -- (optional) if False then empty test results are treated as a rule violation and thus
        # #   the release is blocked. Defaults to True. An empty result may appear due to the following reasons:
        # #   - test has not started yet
        # #   - test does not support TestResult specification
        # #
        # # Predefined constants:
        # # - `REQUIRE_ALL_OK` -- require all supported tests to be in OK status
        # # - `REQUIRE_NO_CRITS` -- require that there are not CRITs among the supported tests
        # # - `REQUIRE_ALL_FINISHED` -- block until all supported tests are finished
        # # - `NEVER_BLOCK` -- never block release (i.e., do not check any test statuses)
        # #
        # #
        # # Example 1:
        # # `block_conf(name_filter='TEST_*', accept_result_threshold=release_block.OK)`
        # # -- requires all tests with names starting with 'TEST_' to finish in OK status (blocks release otherwise)
        # #
        # # Example 2:
        # # `block_conf(name_filter=re.compile(r'TEST_[A-Z_]+_IMPORTANT'), accept_result_threshold=release_block.WARN)`
        # # -- requires all test with names that match the given regular expression to finish with at least a warning
        # # (e.g., if a test named 'TEST_SOMETHING_IMPORTANT' is in CRIT or ONGOING then the release will be blocked)
        # #
        # # See more examples in sandbox/projects/release_machine/components/config_core/release_block.py
        # #
        # block_on_test_results = [release_block.NEVER_BLOCK]

    class MetricsCfg(cfg.ReferenceBranchedConfig.MetricsCfg):
        """ Metrics configuration """
        limit_s = 14 * 60 * 60          # Limit for SERPs downloads (in seconds)
        default_launch_id = ""          # Default launch ID

    class Yappy(cfg.ReferenceBranchedConfig.Yappy):
        working_betas_limit = 3
        wait_for_deploy_time_sec = 4 * 60 * 60
        betas = {}
