# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs as cfg
# from sandbox.projects.release_machine.core import const as rm_const


class ComponentNameCfg(cfg.ReferenceTrunkConfig):
    """
    Configuration template for components with trunk release cycle.

    All properties that are NOT commented are mandatory.
    Commented properties and methods are optional.
    """

    # Component main identifier.
    #
    # Requirements:
    # - Must be unique
    # - Must follow PEP8 [function and variable naming convention]
    # (https://www.python.org/dev/peps/pep-0008/#function-and-variable-names)
    #
    # Example: `"my_shiny_component"`
    name = ""

    # # Display name of the component shown in UI
    # #
    # # Example: `"My Shiny Component"`
    # display_name = ""

    # Username of the person responsible for the component
    #
    # Example: `"jondoe"`
    responsible = ""

    class Releases(cfg.ReferenceTrunkConfig.Releases):
        pass
        # # Allow releases from older branches
        # #
        # # When set to `False` (default) helps preventing race conditions
        # # and occasional releases from obsolete branches
        # #
        # # Could be dict with release stages as key for fine tuning. Example
        # # allow_old_releases = {rm_const.ReleaseStatus.stable: False, rm_const.ReleaseStatus.testing: True}
        # #
        # # Default: `False`
        # allow_old_releases = False

        # # Whether to allow robot to release to stable
        # #
        # # When set to `True` allows automatic release to stable.
        # # Otherwise `ReleaseRMComponent` would not perform a stable
        # # release unless its author is a human being
        # #
        # # Default: `False`
        # allow_robots_to_release_stable = False

        # # A list of release followers
        # #
        # # Defines a list of usernames that should always be set as followers
        # # of release tickets
        # #
        # # Default: `[]`
        # release_followers_permanent = []

        # # Deploy system for the component
        # #
        # deploy_system = rm_const.DeploySystem.nanny

        # # Wait for deploy time (in seconds)
        # #
        # # How long should release task wait for component deployment
        # # before finishing
        # #
        # wait_for_deploy_time_sec = 4 * 60 * 60

    class Testenv(cfg.ReferenceTrunkConfig.Testenv):
        """
        TestEnv configuration settings
        """

        # Your team sandbox-group
        #
        # This sandbox group will be set as task owner for tasks run by TestEnv
        #
        # Example: `"SEARCH-RELEASERS"`
        trunk_task_owner = ""

        # # List of logins that should be added to testenv trunk db
        # # Used in PrepareRmComponentEnvironment and CloneTestenvDb
        # #
        # # Example: `['mvel', 'glebov-da', 'ilyaturuntaev']`
        # #
        # # Default: `[]`
        # testenv_db_owners = []

        # # TestEnv trunk DB
        # #
        # # Default: `"{name}-trunk".format(name=name)`
        # trunk_db = ""

        # # Testenv main DB template
        # #
        # # May include one positional replacement (will be replaces with component name)
        # #
        # # Default: `trunk_db`
        # db_template = ""

    class Notify(cfg.ReferenceTrunkConfig.Notify):
        """ Notification settings """

        # # Whether to use Startrek stuff or not
        # #
        # # Set to True (and provide an appropriate Startrek config) if you're going to use
        # # Startrek release tickets and some relative functionality. When set to False
        # # (default) you don't have to provide any Startrek configuration
        # #
        # # Default: `False`
        # use_startrek = False

        # class Mail(cfg.ReferenceTrunkConfig.Notify.Mail):
        #     """ Mail notifications """
        #
        #     # # Mailing list
        #     # #
        #     # # A list of email addresses that should receive email notifications
        #     # #
        #     # # Default = `["search-components-releases"]`
        #     # mailing_list = ["search-components-releases"]

        # class Telegram(cfg.ReferenceTrunkConfig.Notify.Telegram):
        #     """ Telegram notifications """
        #
        #     # # Read more about RM notifications on https://wiki.yandex-team.ru/releasemachine/notifications/
        #
        #     # # Telegram chat
        #     # #
        #     # # Name of the Telegram chat as defined in `projects/common/release_machine/core/const/__init__.py`.
        #     # # This chat will receive various notifications
        #     # #
        #     # # Example: `"rm_maintainers"`
        #     # #
        #     # # Default: `[]`
        #     # chats = []
        #
        #     # # Your Telegram chat invite link
        #     # #
        #     # # Example: `"https://t.me/joinchat/AAAAAEN49wUGP2uImQ6Dfw"`
        #     # #
        #     # # Default: `None`
        #     # invite_link = None

    # class ChangelogCfg(cfg.ReferenceTrunkConfig.ChangelogCfg):
    #     """
    #     Changelog configuration
    #
    #     https://wiki.yandex-team.ru/releasemachine/changelogs/
    #     """
    #
    #     # Directories to get changelog revisions from
    #     #
    #     # Defines a list of SVN paths that will be used to obtain changelog from (via `SVN log`).
    #     # If empty then the log is obtained from 'arcadia:/arc/trunk'.
    #     # todo: Path format seems to be not fixed -- find out and present actual format here
    #     #
    #     # Example:
    #     # ```
    #     # [
    #     #     "arcadia/sandbox/projects/common/search/release_web",
    #     #     "arcadia/sandbox/projects/common/release_machine",
    #     # ]
    #     # ```
    #     dirs = []
    #
    #     # Changelog wiki pages path
    #     #
    #     # Defines a path to the root directory of changelog wiki pages. It is often built in the following
    #     # format: 'jandekspoisk/kachestvopoiska/{component_name}/releases/' (where {component_name}) is
    #     # the component name. E.g., if you set `wiki_page = "jandekspoisk/kachestvopoiska/myshinycomponent/releases/"`
    #     # then your changelog wiki pages' paths would look like
    #     # `"jandekspoisk/kachestvopoiska/myshinycomponent/releases/stable-1"`,
    #     #
    #     # Example: `"jandekspoisk/kachestvopoiska/myshinycomponent/releases/"`
    #     wiki_page = ""
    #
    #     # # Wiki page owner (defaults to the component's responsible)
    #     # #
    #     # # Username of the user who should possess read/write privileges to changelog wiki pages.
    #     # # Defaults to the `responsible` for the component
    #     # #
    #     # # Default: `responsible`
    #     # wiki_page_owner = ""
    #
    #     # # Wiki page head template
    #     # #
    #     # # Formatstring for changelog wiki page header. Must include the following named replacement fields:
    #     # # - `descr` -- release path
    #     # # - `r1` -- first revision
    #     # # - `r2` -- last revision
    #     # # - `date` -- creation date
    #     # #
    #     # wiki_head_template = "===={descr} //r:{r1}-{r2}//\nCreation date: {date}"
    #
    #     # # Changelog wiki page time-to-live in days
    #     # #
    #     # # Unless `None`, defines an amount of days for changelog wiki page to live.
    #     # # Wiki page is deleted after `wiki_page_ttl_days` passed since its creation.
    #     # # `None` means that pages should live forever.
    #     # #
    #     # # Default: `None`
    #     # wiki_page_ttl_days = None       # Remove wiki pages after this amount of days (don't if None)
    #
    #     # # Changelog markers
    #     # #
    #     # # `list` or `None`
    #     # #
    #     # # Used to filter commits when building a changelog.
    #     # # When not `None` should define a list of tuples (importance, compiled_regexp)
    #     # # Only the commits with messages that match either of these
    #     # # regular expressions are added to the result changelog.
    #     # #
    #     # # If `markers` is `None` commit messages will not be parsed
    #     # #
    #     # # Example:
    #     # # ```
    #     # # [
    #     # #     (4, re.compile(r"\bdiff *: *(begemot|wizard)", flags=re.IGNORECASE)),
    #     # # ]
    #     # #```
    #     # #
    #     # # Default: `None`
    #     # markers = None
    #
    #     # # Review groups scanned for commits
    #     # #
    #     # # This is used to get changelog from reviews. `review_groups` defines a list of
    #     # # Arcanum review group names. RM looks for commits in these groups and adds the
    #     # # appropriate info to changelog
    #     # #
    #     # # Example: `['review_group_1', 'review_group_2']`
    #     # #
    #     # # Default: `[]`
    #     # review_groups = []
    #
    #     # @staticmethod
    #     # def calculate_importance(changelog_entry):
    #     #     """
    #     #     Calculate commit importance, which depends on commit paths.
    #     #     Default value is the mark of the given `changelog_entry`.
    #     #     """
    #     #     return cfg.ReferenceTrunkConfig.ChangelogCfg.calculate_importance(changelog_entry)

    # class MetricsCfg(cfg.ReferenceTrunkConfig.MetricsCfg):
    #     """ Metrics configuration """
    #     limit_s = 14 * 60 * 60          # Default limit for SERPs downloads (in seconds)
    #     default_launch_id = ""          # Default launch ID
