# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core.jg import cube as jg_cube
from sandbox.projects.release_machine.components.config_core.jg import flow as jg_flow
from sandbox.projects.release_machine.components.config_core.jg.cube import base as cube_base
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import dummy as dummy_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import meta_test as meta_test_cubes
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test

from sandbox.projects.common.constants import constants as common_const

import os


NOTIFY_ON_COMPONENT_VERSION_CHANGE_TO_FEATURE_TICKETS = frozenset([
    "DEPLOY",
    "ISS",
    "SWAT",
    "YP",
    "YPADMIN",
    "YTORM",
])


YT_TEST_PATHS = (
    "yt/yt/orm",
    "yt/yt/core",
    "yt/yt/library",
    "yt/yt/ytlib",
    "yt/yt/client"
)

YP_TEST_PATHS = (
    "yp/client/api/unittests",
    "yp/server/unittests",
    "yp/tests",
)


def get_yp_tests_job_name():
    return "YP"


def get_yt_tests_job_name():
    return "YT"


def get_yp_build_job_name(name=None):
    if name is not None:
        return name
    else:
        return ""


def create_tests_job(paths, name):
    sandbox_task_requirements = dict(
        ram=128 * (1024 ** 3),
        disk_space=2 * (1024 ** 4),
    )
    timeout = 5 * 60 * 60
    return jg_test.JobGraphElementMetaTestBranched(
        job_params={
            "job_name_parameter": name,
            "apiargs": {
                "requirements": sandbox_task_requirements,
                "kill_timeout": timeout,
            },
        },
        ctx=ya_make_test_params(paths, timeout),
    )


def ya_make_test_params(paths, timeout=4 * 60 * 60 - 1):
    assert timeout < 4 * 60 * 60, "Distbuild timeout must be smaller than 4 hours, but got {} seconds".format(timeout)
    return {
        common_const.BUILD_SYSTEM_KEY: common_const.DISTBUILD_BUILD_SYSTEM,
        common_const.BUILD_TYPE_KEY: common_const.RELEASE_WITH_DEBUG_INFO_BUILD_TYPE,
        common_const.USE_AAPI_FUSE: True,
        common_const.ALLOW_AAPI_FALLBACK: False,
        common_const.DOWNLOAD_ARTIFACTS_FROM_DISTBUILD: True,
        common_const.REPORT_TESTS_ONLY: True,
        common_const.CHECK_RETURN_CODE: True,  # Report about any infrastructure error directly.
        common_const.FAILED_TESTS_CAUSE_ERROR: False,  # Report about failed tests indirectly via results.json.
        common_const.TEST_SIZE_FILTER: "small,medium",
        common_const.YA_TIMEOUT: timeout,
        "cache_test_results": False,
        "test": True,
        "test_retries": 1,
        "targets": ";".join(paths),
        "ram_drive_size": 70 * 1024,
        "junit_report": True,
        "distbuild_pool": "//sas/users/yp",
        "env_vars": "YA_TOKEN='$(vault:value:robot-yp-releaser:robot-yp-releaser-ya-token)'",
    }


def create_yt_tests_job():
    return create_tests_job(
        paths=list(YT_TEST_PATHS),
        name=get_yt_tests_job_name(),
    )


def create_yp_tests_job():
    return create_tests_job(
        paths=list(YP_TEST_PATHS),
        name=get_yp_tests_job_name(),
    )


def create_yp_build_cube(name, needs, path, resource_description, resource_type):
    return jg_cube.Cube(
        name=name,
        needs=needs,
        task="common/nanny/kosher_ya_make",
        input=cube_base.CubeInput(**{
            common_const.USE_AAPI_FUSE: True,
            common_const.ALLOW_AAPI_FALLBACK: True,
            common_const.BUILD_SYSTEM_KEY: common_const.SEMI_DISTBUILD_BUILD_SYSTEM,
            common_const.BUILD_TYPE_KEY: common_const.RELEASE_BUILD_TYPE,
            common_const.CHECK_RETURN_CODE: True,
            common_const.FORCE_VCS_INFO_UPDATE: True,
            "arts": path,
            "result_rd": resource_description,
            "result_rt": resource_type,
            "result_single_file": True,
            "result_ttl": "inf",
            "targets": os.path.dirname(path),
        }),
    )


class YPTestCube:
    def __init__(self, name, paths):
        self.name = name
        self.paths = paths


class YPBuildCube:
    def __init__(self, name, path, resource_description, resource_type):
        self.name = name
        self.path = path
        self.resource_description = resource_description
        self.resource_type = resource_type


# Must not be imported into the final config file as it forces Release Machine to process two configs in one file.
class YPConfigBase(configs.ReferenceCIConfig):
    # Common parameters.
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="yp"),
        login="robot-yp-releaser",
    )


class YPJobGraph(basic_build_presets.SingleBuildYaMakeJGCfg):
    build_task = "KOSHER_YA_MAKE"

    # List of #YPTestCube items.
    yp_test_cubes = None

    # List of #YPBuildCube items.
    yp_build_cubes = None

    # Preset does not run tests and does not build non-releasable items by default,
    # so the job graph must be patched.
    @jg_flow.release_flow(stages=basic_build_presets.JOINED_BUILD_RELEASE_FLOW_STAGES)
    def release(self):
        graph = super(YPJobGraph, self).release(self)
        main_entry = graph.get(dummy_cubes.RMMainGraphEntry.NAME)
        release_entry = graph.get("release_stage_entry")

        yp_test_cubes = self.yp_test_cubes
        if yp_test_cubes is None:
            yp_test_cubes = []
        for yp_cube in yp_test_cubes:
            cube = meta_test_cubes.MetaTest(
                targets=yp_cube.paths,
                name=yp_cube.name,
                needs=[main_entry],
                input=cube_base.CubeInput(**ya_make_test_params(yp_cube.paths)),
            )
            release_entry.add_requirement(cube)
            graph.add(cube)

        yp_build_cubes = self.yp_build_cubes
        if yp_build_cubes is None:
            yp_build_cubes = []
        for yp_cube in yp_build_cubes:
            cube = create_yp_build_cube(
                name=yp_cube.name,
                needs=[main_entry],
                path=yp_cube.path,
                resource_description=yp_cube.resource_description,
                resource_type=yp_cube.resource_type,
            )
            release_entry.add_requirement(cube)
            graph.add(cube)

        return graph
