# -*- coding: utf-8 -*-
import os

from sandbox.projects.ab_testing import rm_test_config as abrtc
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.components import configs
# FIXME(mvel): bad search_integration_env should be moved to common
from sandbox.projects.release_machine.components.configs.report import search_integration_env
import sandbox.projects.release_machine.components.config_core.release_block as release_block
import sandbox.projects.release_machine.components.config_core.statistics_page as statistics_page
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_job_arrows
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


# TODO: unify this (in flags maybe too)
def custom_mlm_description(testid, experiment_id):
    return (
        "Compare 'pure hamster' vs 'hamster+testid {testid}', "
        "((https://ab.yandex-team.ru/task/{experiment_id} {experiment_id}))"
    ).format(
        testid=testid,
        experiment_id=experiment_id,
    )


# TODO: unify this
def test_results_message(x, params):
    return "Test results of testid (({}component/ab_experiments/manage?tag={}&scopes=1 {}))".format(
        rm_const.Urls.RM_URL, params.revision, x
    )


def search_integration_env_ab(testid, params):
    return " ".join([
        search_integration_env("hamster", "yandex.ru"),
        "EXP_CONFS=testing",
        "TEST_ID={}".format(testid)
    ])


class AbExperimentsCfg(configs.ReferenceTaggedConfig):
    name = "ab_experiments"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="ups", component_id=33085),
        login="glebov-da",
    )

    class Releases(configs.ReferenceTaggedConfig.Releases):
        resources_info = []

        @property
        def block_on_test_results(self):
            return [
                release_block.block_conf(
                    name_filter=rm_const.JobTypes.rm_job_name(rm_const.JobTypes.TEST, self.name, "MIDDLE*"),
                    accept_result_threshold=release_block.WARN,
                    ignore_empty=False,
                ),
                release_block.block_conf(
                    name_filter=rm_const.JobTypes.rm_job_name(rm_const.JobTypes.TEST, self.name, "UPPER*"),
                    accept_result_threshold=release_block.WARN,
                    ignore_empty=False,
                ),
                release_block.block_conf(
                    name_filter=rm_const.JobTypes.rm_job_name(rm_const.JobTypes.TEST, self.name, "METRICS*"),
                    accept_result_threshold=release_block.WARN,
                    ignore_empty=False,
                ),
                release_block.block_conf(
                    name_filter=rm_const.JobTypes.rm_job_name(rm_const.JobTypes.TEST, self.name, "MARKET_REPORT_LITE*"),
                    accept_result_threshold=release_block.WARN,
                    ignore_empty=False,
                ),
                release_block.block_conf(
                    name_filter=rm_const.JobTypes.rm_job_name(rm_const.JobTypes.TEST, self.name, "LAUNCH_ZEN_EXPERIMENT*"),
                    accept_result_threshold=release_block.WARN,
                    ignore_empty=False,
                ),
                release_block.block_conf(
                    name_filter=rm_const.JobTypes.rm_job_name(rm_const.JobTypes.TEST, self.name, "YABS_SERVER*"),
                    accept_result_threshold=release_block.WARN,
                    ignore_empty=False,
                ),
            ]

    class Testenv(configs.ReferenceTaggedConfig.Testenv):
        trunk_task_owner = "EXPERIMENTS"
        trunk_db = "ab_experiments"

        class JobGraph(configs.ReferenceTaggedConfig.Testenv.JobGraph):
            @property
            def _tag_part(self):
                # no super method here! this component is very custom
                test_job_triggers = (
                    jg_job_triggers.JobTriggerTestBranchCommon(job_name_parameter="MIDDLE_WEB"),
                    jg_job_triggers.JobTriggerTestBranchCommon(job_name_parameter="UPPER_WEB"),
                    jg_job_triggers.JobTriggerTestBranchCommon(job_name_parameter="METRICS_WEB"),
                    jg_job_triggers.JobTriggerTestBranchCommon(job_name_parameter="METRICS_IMAGES"),
                    jg_job_triggers.JobTriggerTestBranchCommon(job_name_parameter="METRICS_VIDEO"),
                    jg_job_triggers.JobTriggerTestBranchCommon(job_name_parameter="MARKET_REPORT_LITE"),
                    jg_job_triggers.JobTriggerTestBranchCommon(job_name_parameter="MARKET_REPORT_PERF_TEST"),
                    jg_job_triggers.JobTriggerTestBranchCommon(job_name_parameter="YABS_SERVER"),
                )
                result = [
                    jg_build.JobGraphElementBuildTagged(
                        task_name="RUN_AB_TESTS",
                        job_arrows=jg_job_arrows.ParamsData(
                            input_key="test_id_revision",
                            transform=lambda params, rm_config: params.revision,
                        ),
                        job_params=abrtc.job_params(),
                    ),
                    jg_release.JobGraphElementNewTagTagged(
                        job_params=abrtc.job_params(
                            ctx={"fail_on_existing_tag": False},
                        ),
                        job_arrows=(
                            jg_job_arrows.ParamsData("custom_tag_number", lambda params, rm_config: params.revision),
                        ),
                    ),
                    # jg_test.JobGraphElementSearchIntegrationTestidTest(
                    #    job_params=abrtc.job_params(),
                    #    frequency=(jg_utils.TestFrequency.EVERY_N_COMMIT, 4),
                    # ),
                    jg_test.JobGraphElementTestTagCommon(
                        task_name="CHECK_MIDDLE_EXP",
                        job_params=abrtc.job_params(job_name_parameter='MIDDLE_WEB'),
                        job_arrows=jg_job_triggers.JobTriggerBuild(
                            parent_job_data=(
                                jg_job_data.ParentDataOutput("save_event_log", "web__middle__save_eventlog"),
                                jg_job_data.ParentDataOutput("scraper_pool", "web__middle__scraper_pool"),
                                jg_job_data.ParentDataOutput("new_cgi_param", "web__middle__new_cgi_param"),
                                jg_job_data.ParentDataOutput("ab_experiment_id", "experiment_id"),
                            ),
                        ),
                    ),
                    jg_test.JobGraphElementTestTagCommon(
                        task_name="CHECK_UPPER_EXP",
                        job_params=abrtc.job_params(job_name_parameter='UPPER_WEB'),
                        job_arrows=jg_job_triggers.JobTriggerBuild(
                            parent_job_data=(
                                jg_job_data.ParentDataOutput("save_event_log", "web__upper__save_eventlog"),
                                jg_job_data.ParentDataOutput("scraper_pool", "web__upper__scraper_pool"),
                                jg_job_data.ParentDataOutput("new_cgi_param", "web__upper__new_cgi_param"),
                                jg_job_data.ParentDataOutput("ab_experiment_id", "experiment_id"),
                            ),
                        ),
                    ),
                    jg_test.JobGraphElementTestTagCommon(
                        task_name="MARKET_REPORT_LITE_TESTS_EXP",
                        job_params=abrtc.job_params(job_name_parameter='MARKET_REPORT_LITE'),
                        job_arrows=jg_job_triggers.JobTriggerBuild(
                            parent_job_data=(
                                jg_job_data.ParentDataOutput("run_tests", "market__report_lite_tests_exp__run_tests"),
                                jg_job_data.ParentDataOutput(
                                    "rearr_factors", "market__report_lite_tests_exp__rearr_factors"
                                ),
                            ),
                        ),
                    ),
                    jg_test.JobGraphElementTestTagCommon(
                        task_name="MARKET_REPORT_PERF_TEST_EXP",
                        job_params=abrtc.job_params(job_name_parameter='MARKET_REPORT_PERF_TEST'),
                        job_arrows=jg_job_triggers.JobTriggerBuild(
                            parent_job_data=(
                                jg_job_data.ParentDataOutput("run_tests", "market__report_lite_tests_exp__run_tests"),
                                jg_job_data.ParentDataOutput(
                                    "rearr_factors", "market__report_lite_tests_exp__rearr_factors"
                                ),
                                jg_job_data.ParentDataOutput("ticket", "experiment_id"),
                            ),
                        ),
                    ),
                    jg_test.JobGraphElementTestTagCommon(
                        task_name="ALICE_EVO_INTEGRATION_TESTS_WRAPPER",
                        job_params=abrtc.job_params(
                            job_name_parameter='ALICE_EVO_INTEGRATION_TESTS_WRAPPER',
                            frequency=(jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        ),
                        ctx={
                            "repeat_failed_test": True,
                            "run_call_owner_subtask": True,
                        },
                        job_arrows=jg_job_triggers.JobTriggerBuild(
                            parent_job_data=(
                                jg_job_data.ParentDataOutput("release_ticket", "experiment_id"),
                                jg_job_data.ParentDataOutput("ab_testid", "testid"),
                                jg_job_data.ParentDataOutput("dry_run", "alice__dry_run"),
                                jg_job_data.ParentDataOutput("experiments", "alice__experiment_flags"),
                                jg_job_data.ParentDataOutput("launch_type", "alice__launch_type"),
                            )
                        )
                    ),
                    jg_test.JobGraphElementTestTagCommon(
                        task_name="LAUNCH_ZEN_EXPERIMENT_TESTS",
                        job_params=abrtc.job_params(
                            job_name_parameter='LAUNCH_ZEN_EXPERIMENT_TESTS',
                            frequency=(jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        ),
                        job_arrows=jg_job_triggers.JobTriggerBuild(
                            parent_job_data=(
                                jg_job_data.ParentDataOutput("experiment_ticket", "experiment_id"),
                                jg_job_data.ParentDataOutput("experiment_testid", "testid"),
                                jg_job_data.ParentDataOutput("experiment_flags", "zen__experiment_flags"),
                                jg_job_data.ParentDataOutput("skip_test", "zen__skip_test"),
                            )
                        )
                    ),
                    jg_test.JobGraphElementTestTagCommon(
                        task_name="YABS_SERVER_TEST_AB_EXPERIMENT",
                        job_params=abrtc.job_params(
                            job_name_parameter='YABS_SERVER',
                            frequency=(jg_utils.TestFrequency.LAZY, None),
                        ),
                        job_arrows=jg_job_triggers.JobTriggerBuild(
                            parent_job_data=(
                                jg_job_data.ParentDataOutput("dry_run", "bigb_main__dry_run"),
                                jg_job_data.ParentDataOutput("ab_experiment_settings",
                                                             "bigb_main__ab_experiment_settings"),
                                jg_job_data.ParentDataOutput("ft_meta_modes", "bigb_main__ft_meta_modes"),
                            ),
                        ),
                    ),
                    jg_test.JobGraphElementActionRunAcceptanceTagged(
                        job_params=abrtc.job_params(
                            ignore_parent_job_error=True,
                            required_parent_tests_to_run=[i.this_job_name(self.name) for i in test_job_triggers],
                            ctx={
                                "autotesting_ok": False,
                            },
                        ),
                        job_arrows=(
                            jg_job_arrows.ParamsData(
                                input_key="release_num",
                                transform=lambda params, rm_config: params.revision,
                            ),
                            jg_job_triggers.JobTriggerNewTag(),
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput("notify_ticket", "experiment_id"),
                                    jg_job_data.ParentDataOutput(
                                        "notify_message",
                                        "testid",
                                        test_results_message
                                    ),
                                ),
                            ),
                        ) + test_job_triggers
                    )
                ]
                metrics_params = [
                    "custom_template_name",
                    "scraper_over_yt_pool",
                    "sample_beta",
                    "checked_beta",
                    "checked_extra_params",
                    "optimistic_expected_launch_time_sec",
                    "enable_autoclicker",
                    "autoclicker_retry_count",
                    "autoclicker_metric_name",
                ]
                for search_subtype in ["web", "images", "video"]:
                    result.append(jg_test.JobGraphElementTestTagCommon(
                        task_name="LAUNCH_METRICS",
                        job_params=abrtc.job_params(
                            job_name_parameter='METRICS_{}'.format(search_subtype.upper()),
                        ),
                        ctx={
                            "search_subtype": search_subtype,
                            "metrics_mode_type": "release_machine",
                            "template_source": "last_released",
                        },
                        job_arrows=(
                            jg_job_arrows.ParamsData("release_number", transform=lambda x, _: x.revision),
                            jg_job_arrows.ParentsData(
                                input_key="custom_template_descr",
                                triggers=(jg_job_triggers.JobTriggerBuild(
                                    parent_job_data=[
                                        jg_job_data.ParentDataOutput("experiment_id", "experiment_id"),
                                        jg_job_data.ParentDataOutput("testid", "testid"),
                                    ],
                                )),
                                transform=custom_mlm_description,
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=[
                                    jg_job_data.ParentDataOutput("ab_experiment_id", "experiment_id"),
                                ] + [
                                    jg_job_data.ParentDataOutput(i, "{}__metrics__{}".format(search_subtype, i))
                                    for i in metrics_params
                                ],
                            ),
                        )
                    ))
                return result

            @property
            def _release(self):
                return []  # no release here

    class SvnCfg(configs.ReferenceTaggedConfig.SvnCfg):
        tag_prefix = "r"
        tag_name = "experiments"

        @property
        def main_url(self):
            return os.path.join(
                self.repo_base_url, "trunk", "arcadia", "quality", "robots", "ab_testing", "experiments"
            )

    class Notify(configs.ReferenceTaggedConfig.Notify):
        use_startrek = False

    class ChangelogCfg(configs.ReferenceTaggedConfig.ChangelogCfg):
        dirs = ["."]  # all changes in main url
        wiki_page = ""

    class MetricsCfg(object):
        limit_s = 10800  # 3 hours

    class ReleaseViewer(configs.ReferenceTaggedConfig.ReleaseViewer):
        statistics_page_charts = [statistics_page.PredefinedCharts.TIMESPECTRE_METRICS]

    def __init__(self):
        super(AbExperimentsCfg, self).__init__()
        self.changelog_cfg = self.ChangelogCfg(self, self.svn_cfg.main_url, self.responsible)
