# -*- coding: utf-8 -*-
import os

from sandbox.projects.ab_testing import rm_test_config as abrtc
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.components.configs import ab_flags_testids
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_job_arrows
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers


# TODO: remove copypaste
def test_results_message(x, params):
    return "Test results of testid (({}component/ab_flags/manage?tag={}&scopes=1 {}))".format(
        rm_const.Urls.RM_URL, params.revision, x
    )


def make_uniproxy_url(test_id, params):
    return "wss://beta.uniproxy.alice.yandex.net/alice-uniproxy-hamster/uni.ws?test-id={}".format(test_id)


class AbFlagsCfg(ab_flags_testids.AbFlagsTestidsCfg):
    name = "ab_flags"
    responsible = "mvel"

    class Releases(ab_flags_testids.AbFlagsTestidsCfg.Releases):
        resources_info = []

        @property
        def block_on_test_results(self):
            block_list = super(self.__class__, self).block_on_test_results
            return block_list

    class Testenv(ab_flags_testids.AbFlagsTestidsCfg.Testenv):
        trunk_task_owner = "EXPERIMENTS"
        trunk_db = "ab_flags"

        class JobGraph(ab_flags_testids.AbFlagsTestidsCfg.Testenv.JobGraph):
            @property
            def _tag_part(self):
                tag_part = super(AbFlagsCfg.Testenv.JobGraph, self)._tag_part

                additional_test_job_triggers = (
                    jg_job_triggers.JobTriggerTestBranchCommon(job_name_parameter="WEB_DEV"),
                    jg_job_triggers.JobTriggerTestBranchCommon(job_name_parameter="ALICE_EVO_INTEGRATION_TESTS"),
                )

                tag_part.extend([
                    jg_test.JobGraphElementTestTagCommon(
                        task_name="SANDBOX_CI_WEB4_EXPERIMENTS_RELEASE_RUNNER",
                        ctx={
                            "allow_data_flags": True,
                            "release": "specify",
                            "project_git_base_ref": "dev",
                            "hermionee2e_base_url": "https://renderer-web4-dev.hamster.yandex.ru",
                            "tests_source": "dev",
                            "release_machine_mode": True,
                        },
                        job_params=abrtc.job_params(
                            job_name_parameter="WEB_DEV",
                        ),
                        job_arrows=jg_job_triggers.JobTriggerBuild(
                            parent_job_data=(
                                jg_job_data.ParentDataOutput("test_id", "testid"),
                                jg_job_data.ParentDataOutput("description", "web__runner__dev_description"),
                                jg_job_data.ParentDataOutput("run_flags_mode", "web__runner__run_flags_mode"),
                            ),
                        ),
                    ),
                    jg_test.JobGraphElementTestTagCommon(
                        task_name="ALICE_EVO_INTEGRATION_TESTS_WRAPPER",
                        job_params={
                            "job_name_parameter": "ALICE_EVO_INTEGRATION_TESTS",
                        },
                        job_arrows=jg_job_triggers.JobTriggerBuild(
                            parent_job_data=(
                                jg_job_data.ParentDataOutput("uniproxy_url", "testid", make_uniproxy_url),
                                jg_job_arrows.JustPassData("experiments", "disregard_uaas: None"),
                                jg_job_arrows.JustPassData("launch_type", "ab_flags"),
                            )
                        )
                    ),
                    jg_test.JobGraphElementSearchIntegrationTestidTest(
                        job_params=abrtc.job_params(),
                    ),
                ])

                for job in tag_part:
                    if job.job_params["task_name"] == "CONFIGURE_AB_FLAGS_TESTS":
                        job.job_params["ctx"]["run_type"] = "BULK_TESTS"
                    elif job.job_params["job_type"] == rm_const.JobTypes.ACTION_RUN_ACCEPTANCE:
                        job.job_params["required_parent_tests_to_run"].extend([
                            i.this_job_name(self.name) for i in additional_test_job_triggers
                        ])
                        job.job_arrows += tuple(additional_test_job_triggers)

                # Release approvement JGE
                tag_part.append(
                    jg_release.JobGraphElementStartrekOkApprovementTagged(
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput("ticket_key", "experiment_id"),
                                    jg_job_data.ParentDataOutput(
                                        "approvers",
                                        "service_responsibles",
                                        transform=(
                                            lambda space_separated_items, params: space_separated_items.split(" ")
                                        ),
                                    ),
                                )
                            ),
                        ),
                        ctx={
                            "mode": "custom",
                            "text": "Please confirm this release",
                        },
                    ),
                )

                return tag_part

            @property
            def _release(self):
                return []  # no release here

    class SvnCfg(ab_flags_testids.AbFlagsTestidsCfg.SvnCfg):
        tag_prefix = "r"
        tag_name = "flags"

        @property
        def main_url(self):
            return os.path.join(
                self.repo_base_url, "trunk", "arcadia", "quality", "robots", "ab_testing", "flags",
            )

    def __init__(self):
        super(AbFlagsCfg, self).__init__()
        self.changelog_cfg = self.ChangelogCfg(self, self.svn_cfg.main_url, self.responsible)
