# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components import configs as cfg
import sandbox.projects.Afisha.rm as rm_conf
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import build as build_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import release as release_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import dummy as dummy_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube import base as jg_cube
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import internal as internal_cubes
from sandbox.projects.release_machine.components.config_core.jg import flow as jg_flow


class AfishaBase(cfg.ReferenceCIConfig):

    name = ""
    display_name = ""
    responsible = None
    component_group = rm_conf.COMPONENT_GROUP

    class CI(cfg.ReferenceCIConfig.CI):
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = rm_conf.TRUNK_TASK_OWNER
        a_yaml_dir = ""
        ya_make_abs_paths_glob = []
        grant_config_update_permissions_to_release_machine_robot = False

    class JG(basic_build_presets.SingleBuildGeneralJGCfg):
        teamcity_tests_callback = False
        teamcity_build_id = ""
        semi_distbuild = False
        ya_package_env_vars = None
        docker_build_args = None

        @jg_flow.release_flow(
            stages=[
                basic_build_presets.DEFAULT_STAGE_NEW_TAG,
                basic_build_presets.DEFAULT_STAGE_BUILD,
                jg_flow.ReleaseActionStageData(
                    "release_testing",
                    cube_types=[
                        "release_testing",
                    ],
                    rollback=False,
                    displace=jg_flow.DISPLACE_ON_RUNNING_OR_FAILURE_OR_WAITING,
                ),
                jg_flow.ReleaseActionStageData(
                    "release_stable",
                    cube_names=[
                        dummy_cubes.ReleaseStageEntry.NAME,
                    ],
                    cube_types=[
                        "release_stable",
                    ],
                    rollback=True,
                ),
            ]
        )
        def release(self):
            graph = super(AfishaBase.JG, self).release(self)
            release_entry = graph.get("release_stage_entry")
            try:
                release_prestable = graph.get("release_prestable_sandbox")
            except KeyError:
                release_prestable = None
            release_stable = graph.get("release_stable_sandbox")
            link_feature_tickets = graph.get(internal_cubes.LinkFeatureTickets.NAME)
            post_changelog = graph.get(internal_cubes.PostChangelogToStartrek.NAME)
            build_cube = graph.get("build_afisha_build_docker")

            if self.teamcity_tests_callback:
                release_testing = release_cubes.AfishaRelease2(
                    name="release_testing_sandbox",
                    component_name=self.component_name,
                    where_to_release="testing",
                    manual=False,
                    input=jg_cube.CubeInput(
                        teamcity_callback=True,
                        teamcity_build_id=self.teamcity_build_id,
                    ),
                )
            else:
                release_testing = release_cubes.AfishaRelease2(
                    name="release_testing_sandbox",
                    component_name=self.component_name,
                    where_to_release="testing",
                    manual=False,
                )

            release_testing.add_requirement(link_feature_tickets)
            release_testing.add_requirement(post_changelog)
            release_testing.add_requirement(build_cube)
            release_testing.TYPE = "release_testing"
            if release_prestable:
                go_to_stable = jg_cube.Cube(
                    name="release_prestable_dummy",
                    task="dummy",
                    title="Release Prestable",
                    needs=[release_testing],
                    manual=True,
                )
            else:
                go_to_stable = jg_cube.Cube(
                    name="release_stable_dummy",
                    task="dummy",
                    title="Release Stable",
                    needs=[release_testing],
                    manual=True,
                )
            go_to_stable.TYPE = "release_testing"

            release_entry.TYPE = "release_stable"
            release_entry._set_needs([go_to_stable])
            release_stable.TYPE = "release_stable"
            if release_prestable:
                release_prestable.TYPE = "release_stable"
                release_stable.add_requirement(release_prestable)
                release_prestable.add_requirement(release_entry)
                release_prestable.manual = False
            else:
                release_stable.add_requirement(release_entry)
                release_stable.manual = False
            graph.add(release_testing)
            graph.add(go_to_stable)
            return graph

        @property
        def release_task(self):
            return rm_conf.TASK_CI_REG_LOCATIONS["release2"]

        @property
        def build_task(self):
            return rm_conf.TASK_CI_REG_LOCATIONS["build"]

        def _get_build_cube(self, graph):
            return build_cubes.AfishaBuildDocker(
                component_name=self.component_name,
                package_path=self.root_cfg.releases_cfg.releasable_items[0].build_data.target,
                build_system="semi_distbuild" if self.semi_distbuild else None,
                docker_build_args=self.docker_build_args,
                ya_package_env_vars=self.ya_package_env_vars,
                needs=[graph.get("main_graph_entry"), graph.get(internal_cubes.CreateStartrekTicket.NAME)],
                input=jg_cube.CubeInput(
                    arc_svn_url="arcadia-arc:/#${tasks.new_tag.rm_events[2].new_tag_data.arcadia_path}",
                    checkout_arcadia_from_url="arcadia-arc:/#${tasks.new_tag.rm_events[2].new_tag_data.arcadia_path}",
                ),
            )

        def _get_release_cubes(self, graph, build):
            result = []
            for deploy_system, where, releasable_items in (
                self._iter_over_releasable_items_with_release_stages_and_deploy_systems(build)
            ):
                result.append(
                    release_cubes.AfishaRelease2(
                        name="release_{}_{}".format(where, deploy_system),
                        component_name=self.component_name,
                        where_to_release=where,
                        manual=(True if where in ["stable", "prestable"] else False),
                    )
                )

            return result

    class Notify(cfg.ReferenceCIConfig.Notify):
        """ Notification settings """

        class Telegram(cfg.ReferenceCIConfig.Notify.Telegram):
            """ Telegram notifications """
            chats = ["afisha-releases"]
            invite_link = "https://t.me/joinchat/A7R2dxPqytp73kyN-tywBw"

        class Startrek(cfg.ReferenceCIConfig.Notify.Startrek):
            """
            Startrek notifications
            https://wiki.yandex-team.ru/releasemachine/startrekoptions/
            """
            assignee = ""
            queue = rm_conf.STARTREK_QUEUE
            followers = rm_conf.STARTREK_FOLLOWERS
            summary_template = ""
            add_commiters_as_followers = True
            abc_followers = None
            ticket_type = u"Релиз"
            use_task_author_as_assignee = False
            hide_commits_under_cut = True
            nanny_reports = False
            deadline = 7
            important_changes_limit = rm_conf.IMPORTANT_CHANGES_LIMIT

            def get_controls(self):
                return (
                    u"* тег %%skip_release_{component_name}_{{context.version_info.major}}%% - выключает задачу из цикла для текущего релиза\n"
                    u"* тег %%component_{component_name}%% - привязывает задачу к релизу конкретного компонента(ов). "
                    u"Если нет - все подвязанные релизы считаются связанными\n"
                    u"* компонент %%ProdAction%% - призовет исполнителя (автора) в задачу, когда связанный релиз(ы) доедут до прода\n"
                    u"((https://wiki.yandex-team.ru/alet/ops/release_cycle2/#kontroli Подробнее про контроли))"
                ).format(
                    component_name=self.name,
                )

            ticket_description_suffix = u"=====Контроли релизного цикла для связанных задач\n{}\n\n"

            def __init__(self, name):
                super(AfishaBase.Notify.Startrek, self).__init__(name)
                self.ticket_description_suffix = self.ticket_description_suffix.format(self.get_controls())

            @property
            def tags(self):
                return ["rm_main_ticket", self.name, "component_name_{}".format(self.name)]

    class ChangelogCfg(cfg.ReferenceCIConfig.ChangelogCfg):
        """
        Changelog configuration
        https://wiki.yandex-team.ru/releasemachine/changelogs/
        """
        dirs = []
        wiki_page = ""

    class SvnCfg(cfg.ReferenceCIConfig.SvnCfg):

        branch_name = ""
        tag_name = ""
        start_version = 0
        use_arc = True
        tag_folder_template = "{branch_num}.{tag_num}"
        allow_autobranches = True

    class Releases(cfg.ReferenceCIConfig.Releases):
        """Releases configuration"""

        package_json_path = ""
        prestable_flag = False
        allow_robots_to_release_stable = True
        deploy_system = rm_const.DeploySystem.sandbox

        @property
        def releasable_items(self):
            deploy_infos = [
                ri.SandboxInfo(stage=rm_const.ReleaseStatus.stable),
            ]
            if self.prestable_flag:
                deploy_infos.append(ri.SandboxInfo(stage=rm_const.ReleaseStatus.prestable))
            return [
                ri.ReleasableItem(
                    name=rm_conf.RELEASE_RESOURCE,
                    data=ri.SandboxResourceData(rm_conf.RELEASE_RESOURCE, build_ctx_key="arc_svn_url",
                                                attributes={"component_name": self.name}),
                    build_data=ri.BuildData(
                        target=self.package_json_path,
                    ),
                    deploy_infos=deploy_infos,
                ),
            ]
