# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs as cfg
import sandbox.projects.Afisha.rm as rm_conf
from sandbox.projects.release_machine.components.configs.afisha import _afisha_base as base


class AfishaDraqlaCfg(base.AfishaBase):
    name = "afisha_draqla"  # module name
    display_name = "Afisha Draqla"  # title
    responsible = cfg.Responsible(abc=cfg.Abc(component_id=33883, schedule_slug="afisha-backend-release-duty"), login="msurin")

    class CI(base.AfishaBase.CI):
        a_yaml_dir = "afisha/draqla"  # dir with a.yaml
        ya_make_abs_paths_glob = [
            "afisha/draqla/**",
        ]
        grant_config_update_permissions_to_release_machine_robot = False

    class JG(base.AfishaBase.JG):
        teamcity_tests_callback = True
        teamcity_build_id = "Afisha_All_Ticketsystem_DraqlaApiAutotests"
        semi_distbuild = True

    class Notify(base.AfishaBase.Notify):

        class Startrek(base.AfishaBase.Notify.Startrek):
            summary_template = "Draqla {}"
            followers = rm_conf.STARTREK_FOLLOWERS + ["andreyklitka", "nskosova"]
            assignee = "nskosova"
            abc_followers = cfg.Abc(role_id=8, component_id=109)

    class ChangelogCfg(base.AfishaBase.ChangelogCfg):
        dirs = [  # directories for changelog
            "arcadia/afisha/draqla",
            "arcadia/afisha/common"
        ]
        wiki_page = ""

    class SvnCfg(base.AfishaBase.SvnCfg):
        branch_name = "afisha/draqla"
        tag_name = "afisha/draqla"
        start_version = 159

    class Releases(base.AfishaBase.Releases):
        package_json_path = "afisha/draqla/package.json"
        prestable_flag = True
