# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs as cfg
import sandbox.projects.Afisha.rm as rm_conf
from sandbox.projects.release_machine.components.configs.afisha import _afisha_base as base


class AfishaFrontendCfg(base.AfishaBase):
    name = "afisha_frontend"  # module name
    display_name = "Afisha Frontend"  # title
    responsible = cfg.Responsible(abc=cfg.Abc(component_id=33883, role_id=3316), login="andreyklitka")

    class CI(base.AfishaBase.CI):
        a_yaml_dir = "afisha/frontend/afisha-frontend"  # dir with a.yaml
        ya_make_abs_paths_glob = [
            "afisha/frontend/afisha-frontend/**",
        ]
        grant_config_update_permissions_to_release_machine_robot = False

    class JG(base.AfishaBase.JG):
        ya_package_env_vars = (
            "AWS_ACCESS_KEY_ID=$(vault:value:robot-afisha:robot-afisha.aws_access_key_id) "
            "AWS_SECRET_ACCESS_KEY=$(vault:value:robot-afisha:robot-afisha.aws_secret_access_key)"
        )
        docker_build_args = {
            "BUILD_ENV": "production",
            "AWS_ACCESS_KEY_ID": "None",
            "AWS_SECRET_ACCESS_KEY": "None",
            "AWS_DEFAULT_REGION": "us-east-1",
            "NPM_VERSION": "${context.version_info.major}.${not_null(context.version_info.minor, `0`)}.0",
        }

    class Notify(base.AfishaBase.Notify):

        class Startrek(base.AfishaBase.Notify.Startrek):
            summary_template = "Afisha.Frontend {}"
            followers = rm_conf.STARTREK_FOLLOWERS + ["nskosova", "eredinbg", "andreyklitka"]
            assignee = "andreyklitka"

    class ChangelogCfg(base.AfishaBase.ChangelogCfg):
        dirs = [  # directories for changelog
            "arcadia/afisha/frontend/afisha-frontend",
        ]
        wiki_page = ""

    class SvnCfg(base.AfishaBase.SvnCfg):
        branch_name = "afisha/afisha-frontend"
        tag_name = "afisha/afisha-frontend"
        start_version = 171

    class Releases(base.AfishaBase.Releases):
        package_json_path = "afisha/frontend/afisha-frontend/pkg.json"
